/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.query.QueryByExample;
import ojb.broker.query.QueryFactory;
import org.xml.sax.SAXException;
import test.ojb.broker.Article;
import test.ojb.broker.ProductGroup;
import test.ojb.broker.ProductGroupProxy;

public class BrokerExamples
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$BrokerExamples == null ? (class$test$ojb$broker$BrokerExamples = BrokerExamples.class$("test.ojb.broker.BrokerExamples")) : class$test$ojb$broker$BrokerExamples;
    private int testId = 88888;
    static /* synthetic */ Class class$test$ojb$broker$BrokerExamples;
    static /* synthetic */ Class class$test$ojb$broker$Article;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public BrokerExamples(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        ProductGroup tmpPG = new ProductGroup();
        tmpPG.setId(1);
        Identity pgID = new Identity(tmpPG);
        ProductGroupProxy pgProxy = new ProductGroupProxy(pgID);
        a.setProductGroup(pgProxy);
        return a;
    }

    public void setUp() {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker("repository.xml");
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void tearDown() {
        ObjectCacheFactory.getObjectCache().clear();
    }

    public void testCollectionRetrieval() {
        try {
            int i = 1;
            while (i < 9) {
                ProductGroup example = new ProductGroup();
                example.setId(i);
                ProductGroup group = (ProductGroup)this.broker.getObjectByQuery(QueryFactory.newQuery(example));
                Assert.assertEquals((String)"should be equal", (int)i, (int)group.getId());
                System.out.println(group + "\n\n");
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testModifications() {
        Article article = new Article();
        article.setPrice(2.0);
        article.setStock(0);
        article.setArticleId(this.testId);
        try {
            int i = 1;
            while (i < 50) {
                article.addToStock(10);
                this.broker.store(article);
                this.broker.delete(article);
                this.broker.store(article);
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testObjectCache() {
        try {
            Article tmpArticle = this.createArticle(this.testId);
            Identity tmpOID = new Identity(tmpArticle);
            this.broker.store(tmpArticle);
            ObjectCacheFactory.getObjectCache().clear();
            Article cached = (Article)ObjectCacheFactory.getObjectCache().lookup(tmpOID);
            Assert.assertNull((String)"After flushing Object should be not in cache", (Object)cached);
            Article article = (Article)this.broker.getObjectByQuery(new QueryByExample(tmpOID));
            cached = (Article)ObjectCacheFactory.getObjectCache().lookup(tmpOID);
            Assert.assertNotNull((String)"now object should be found in cache", (Object)cached);
            Assert.assertEquals((String)"should be same reference", (Object)cached, (Object)article);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    protected Article createSimpleArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(false);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    public void testShallowAndDeepRetrieval() {
        try {
            Article tmpArticle = this.createArticle(this.testId);
            Identity tmpOID = new Identity(tmpArticle);
            this.broker.store(tmpArticle);
            ObjectCacheFactory.getObjectCache().clear();
            ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = BrokerExamples.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article);
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)cld.getObjectReferenceDescriptors().get(0);
            ord.setCascadeRetrieve(false);
            Article article = (Article)this.broker.getObjectByQuery(new QueryByExample(tmpOID));
            Assert.assertNull((String)"now reference should be null", (Object)article.getProductGroup());
            ord.setCascadeRetrieve(true);
            article = (Article)this.broker.getObjectByQuery(new QueryByExample(tmpOID));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

