/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.locking;

import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.odmg.locking.LockStrategy;
import ojb.odmg.locking.ReadCommittedStrategy;
import ojb.odmg.locking.ReadUncommittedStrategy;
import ojb.odmg.locking.RepeatableReadStrategy;
import ojb.odmg.locking.SerializableStrategy;

public class LockStrategyFactory {
    private static LockStrategy readUncommitedStrategy = new ReadUncommittedStrategy();
    private static LockStrategy readCommitedStrategy = new ReadCommittedStrategy();
    private static LockStrategy readRepeatableStrategy = new RepeatableReadStrategy();
    private static LockStrategy serializableStrategy = new SerializableStrategy();

    private LockStrategyFactory() {
    }

    public static LockStrategy getStrategyFor(Object obj) {
        int isolationLevel = LockStrategyFactory.getIsolationLevel(obj.getClass());
        switch (isolationLevel) {
            case 0: {
                return readUncommitedStrategy;
            }
            case 1: {
                return readCommitedStrategy;
            }
            case 2: {
                return readRepeatableStrategy;
            }
            case 3: {
                return serializableStrategy;
            }
        }
        return readUncommitedStrategy;
    }

    public static int getIsolationLevel(Class c) {
        int isolationLevel = 0;
        try {
            ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(c);
            isolationLevel = cld.getIsolationLevel();
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            // empty catch block
        }
        return isolationLevel;
    }
}

