/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class BaseConfiguration {
    protected String filename;
    protected Properties properties;

    public BaseConfiguration() {
        this.load();
    }

    protected String getProperty(String key, String defaultValue) {
        ((Hashtable)this.properties).put(key, this.properties.getProperty(key, defaultValue));
        return this.properties.getProperty(key);
    }

    protected void load() {
        this.properties = new Properties();
        try {
            System.out.println("loading configuration from " + new File(this.getFilename()).getAbsolutePath());
            FileInputStream strIn = new FileInputStream(this.getFilename());
            this.properties.load(strIn);
            strIn.close();
        }
        catch (Exception ignore) {
            ((Hashtable)this.properties).put("valid", "false");
        }
    }

    protected String[] parseSeparatedString(String str, String separator) {
        StringTokenizer st = new StringTokenizer(str, separator);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new String(st.nextToken());
            ++i;
        }
        return ret;
    }

    protected void save(String header) {
        try {
            FileOutputStream strOut = new FileOutputStream(this.getFilename());
            this.properties.store(strOut, header);
            strOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getFilename() {
        if (this.filename == null) {
            this.filename = this.getClass().getName() + ".properties";
        }
        return this.filename;
    }

    protected void setFilename(String name) {
        this.filename = name;
    }
}

