/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.io.Serializable;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.openejb.assembler.classic.ComparableValidationConfig;
import org.apache.openejb.bval.ValidatorUtil;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ValidatorFactoryWrapper
implements ValidatorFactory,
Serializable {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, ValidatorFactoryWrapper.class);
    private transient Map<ComparableValidationConfig, ValidatorFactory> fallbackValidators;

    private ValidatorFactory factory() {
        try {
            return ValidatorUtil.lookupFactory();
        }
        catch (NamingException e) {
            if (this.fallbackValidators != null && !this.fallbackValidators.isEmpty()) {
                return this.fallbackValidators.values().iterator().next();
            }
            return ValidatorUtil.tryJndiLaterFactory();
        }
    }

    public ValidatorFactoryWrapper(Map<ComparableValidationConfig, ValidatorFactory> validators) {
        this.fallbackValidators = validators;
    }

    public Validator getValidator() {
        return this.factory().getValidator();
    }

    public ValidatorContext usingContext() {
        return this.factory().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.factory().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.factory().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.factory().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> tClass) {
        return (T)this.factory().unwrap(tClass);
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.factory().getParameterNameProvider();
    }

    public ClockProvider getClockProvider() {
        return this.factory().getClockProvider();
    }

    public void close() {
        this.factory().close();
    }
}

