/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class InterbaseDictionary
extends DBDictionary {
    private static final Localizer _loc = Localizer.forPackage(InterbaseDictionary.class);

    public InterbaseDictionary() {
        this.platform = "Borland Interbase";
        this.validationSQL = "SELECT 1 FROM RDB$DATABASE";
        this.supportsDeferredConstraints = false;
        this.useGetStringForClobs = true;
        this.useSetStringForClobs = true;
        this.useGetBytesForBlobs = true;
        this.useSetBytesForBlobs = true;
        this.maxTableNameLength = 30;
        this.bigintTypeName = "NUMERIC(18,0)";
        this.integerTypeName = "INTEGER";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.charTypeName = "CHAR(1)";
        this.blobTypeName = "BLOB";
        this.clobTypeName = "BLOB SUB_TYPE 1";
        this.bitTypeName = "SMALLINT";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "SMALLINT";
        this.toLowerCaseFunction = null;
        this.stringLengthFunction = null;
    }

    @Override
    protected String getTableNameForMetadata(String tableName) {
        return this.getTableNameForMetadata(DBIdentifier.newTable(tableName));
    }

    @Override
    protected String getTableNameForMetadata(DBIdentifier tableName) {
        if (DBIdentifier.isNull(tableName)) {
            return "%";
        }
        return super.getTableNameForMetadata(tableName);
    }

    @Override
    protected String getColumnNameForMetadata(String columnName) {
        return this.getColumnNameForMetadata(DBIdentifier.newColumn(columnName));
    }

    @Override
    protected String getColumnNameForMetadata(DBIdentifier columnName) {
        if (DBIdentifier.isNull(columnName)) {
            return "%";
        }
        return super.getColumnNameForMetadata(columnName);
    }

    @Override
    protected String appendSize(Column col, String typeName) {
        if (col.isPrimaryKey() && col.getType() == 12) {
            int numKeys = 1;
            if (col.getTable() != null && col.getTable().getPrimaryKey() != null) {
                numKeys = col.getTable().getPrimaryKey().getColumns().length;
            }
            col.setSize(Math.min(col.getSize(), 200 / numKeys));
        } else if (col.getType() == 12 && col.getSize() > 200 && col.getTable() != null) {
            Index[] idx;
            for (Index index : idx = col.getTable().getIndexes()) {
                if (!index.containsColumn(col)) continue;
                col.setSize(Math.min(col.getSize(), 200));
                break;
            }
        }
        return super.appendSize(col, typeName);
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        throw new StoreException(_loc.get("indexof-not-supported", this.platform));
    }

    @Override
    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        throw new StoreException(_loc.get("substring-not-supported", this.platform));
    }

    @Override
    public String[] getDropColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " DROP " + this.getColumnDBName(column)};
    }
}

