/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader.provisining;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.provisining.ArchiveResolver;
import org.apache.openejb.loader.provisining.HttpResolver;
import org.apache.openejb.loader.provisining.MavenResolver;
import org.apache.openejb.loader.provisining.ProvisiningResolverCreated;
import org.apache.openejb.loader.provisining.ProvisioningResolverAware;
import org.apache.openejb.loader.provisining.SimpleUrlResolver;

public class ProvisioningResolver {
    public static final String TEMP_DIR = "temp";
    public static final String OPENEJB_DEPLOYER_CACHE_FOLDER = "openejb.deployer.cache.folder";
    private final Map<String, ArchiveResolver> resolvers = new ConcurrentHashMap<String, ArchiveResolver>();
    private final ArchiveResolver fallbackResolver = new SimpleUrlResolver();

    public ProvisioningResolver() {
        this.resolvers.put("mvn", new MavenResolver());
        this.resolvers.put("http", new HttpResolver());
        this.resolvers.put("https", new HttpResolver());
        if (SystemInstance.isInitialized()) {
            String userOnes = SystemInstance.get().getProperty("openejb.provisinig.archive-resolvers");
            if (userOnes != null) {
                for (String u : userOnes.split(" *, *")) {
                    String c = u.trim();
                    if (!c.isEmpty()) continue;
                    try {
                        ArchiveResolver instance = (ArchiveResolver)ArchiveResolver.class.cast(ProvisioningResolver.class.getClassLoader().loadClass(c));
                        this.addResolver(instance);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            SystemInstance.get().fireEvent(new ProvisiningResolverCreated(this));
        }
        for (ArchiveResolver ar : this.resolvers.values()) {
            if (!ProvisioningResolverAware.class.isInstance(ar)) continue;
            ((ProvisioningResolverAware)ProvisioningResolverAware.class.cast(ar)).setResolver(this);
        }
    }

    public void addResolver(ArchiveResolver resolver) {
        if (this.resolvers.put(resolver.prefix(), resolver) != null) {
            Logger.getLogger(ProvisioningResolver.class.getName()).warning("Overriding resolver " + resolver.prefix() + " with " + String.valueOf(resolver));
        }
    }

    public void removeResolver(ArchiveResolver resolver) {
        this.resolvers.remove(resolver.prefix());
    }

    public Set<String> realLocation(String rawLocation) {
        File destination;
        File file = new File(rawLocation);
        if (file.exists()) {
            return Collections.singleton(file.getAbsolutePath());
        }
        if (rawLocation.endsWith("*.jar")) {
            File dir = new File(rawLocation.substring(0, rawLocation.length() - "*.jar".length()));
            if (dir.exists()) {
                File[] files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") || name.endsWith(".zip");
                    }
                });
                HashSet<String> paths = new HashSet<String>(files == null ? 1 : files.length + 1);
                if (files != null) {
                    for (File f : files) {
                        paths.add(f.getAbsolutePath());
                    }
                }
                paths.add(dir.getAbsolutePath());
                return paths;
            }
            throw new IllegalArgumentException(dir.getAbsolutePath() + " doesn't exist, *.jar is only supported locally");
        }
        String protocol = this.protocol(rawLocation);
        ArchiveResolver resolver = this.resolvers.get(protocol);
        if (resolver == null) {
            resolver = this.fallbackResolver;
        }
        if ((destination = ProvisioningResolver.cacheFile(resolver.name(rawLocation))).exists()) {
            return Collections.singleton(destination.getAbsolutePath());
        }
        return Collections.singleton(this.doResolve(rawLocation, destination, resolver));
    }

    private String protocol(String rawLocation) {
        int sep = rawLocation.indexOf(58);
        if (sep < 1) {
            throw new IllegalArgumentException("Not a local file but no prefix specified: " + rawLocation + ". So can't resolve");
        }
        return rawLocation.substring(0, sep);
    }

    private String doResolve(String rawLocation, File file, ArchiveResolver resolver) {
        InputStream resolverStream = resolver.resolve(rawLocation);
        if (LocalInputStream.class.isInstance(resolverStream)) {
            return ((LocalInputStream)LocalInputStream.class.cast((Object)resolverStream)).path;
        }
        if (resolverStream != null) {
            String string;
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(resolverStream);
                Files.mkdirs(file.getParentFile());
                IO.copy((InputStream)is, file);
                string = file.getAbsolutePath();
            }
            catch (IOException ioe) {
                try {
                    throw new IllegalArgumentException(ioe);
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close(is);
            return string;
        }
        throw new IllegalArgumentException("Could not resolve (" + rawLocation + ")");
    }

    public InputStream resolveStream(String rawLocation) throws MalformedURLException {
        File file = new File(rawLocation);
        if (file.exists()) {
            return new LocalInputStream(file.getAbsolutePath());
        }
        String protocol = this.protocol(rawLocation);
        ArchiveResolver resolver = this.resolvers.get(protocol);
        if (resolver != null) {
            return resolver.resolve(rawLocation);
        }
        return null;
    }

    public static String cache() {
        return System.getProperty(OPENEJB_DEPLOYER_CACHE_FOLDER, TEMP_DIR);
    }

    public static File cacheFile(String path) {
        String cache = ProvisioningResolver.cache();
        if (new File(cache).isAbsolute()) {
            return new File(cache, path);
        }
        return new File(SystemInstance.get().getBase().getDirectory(), cache + File.separator + path);
    }

    public String toString() {
        return "ProvisioningResolver{resolvers=" + String.valueOf(this.resolvers) + ", fallbackResolver=" + String.valueOf(this.fallbackResolver) + "}";
    }

    public static final class LocalInputStream
    extends InputStream {
        private final String path;
        private FileInputStream stream;

        private LocalInputStream(String path) {
            this.path = path;
        }

        private FileInputStream stream() {
            if (this.stream == null) {
                try {
                    this.stream = new FileInputStream(this.path);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.stream;
        }

        @Override
        public int read() throws IOException {
            return this.stream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream().read(b, off, len);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream().mark(readlimit);
        }

        @Override
        public int available() throws IOException {
            return this.stream().available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream().skip(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream().reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream().markSupported();
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
            super.close();
        }
    }
}

