/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.extension;

import jakarta.json.JsonStructure;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public class JsonValueReader<T>
extends Reader
implements Supplier<JsonStructure> {
    private final JsonStructure input;
    private ByteArrayInputStream fallbackDelegate;
    private T result;

    public JsonValueReader(JsonStructure input) {
        this.input = input;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.fallbackDelegate == null) {
            this.fallbackDelegate = new ByteArrayInputStream(this.input.toString().getBytes(StandardCharsets.UTF_8));
        }
        return this.fallbackDelegate.read();
    }

    @Override
    public void close() throws IOException {
        if (this.fallbackDelegate != null) {
            this.fallbackDelegate.close();
        }
    }

    @Override
    public JsonStructure get() {
        return this.input;
    }

    @Deprecated
    public JsonStructure getInput() {
        return this.input;
    }

    @Deprecated
    public T getResult() {
        return this.result;
    }

    @Deprecated
    public void setResult(T result) {
        this.result = result;
    }
}

