/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.transaction.xa.XAResource;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.mdb.AbstractEndpointHandler;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.EndpointHandler;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.mdb.MdbInstanceManager;
import org.apache.openejb.core.mdb.PoolEndpointHandler;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;

public class EndpointFactory
implements MessageEndpointFactory {
    private final ActivationSpec activationSpec;
    private final BaseMdbContainer container;
    private final BeanContext beanContext;
    private final MdbInstanceFactory instanceFactory;
    private final MdbInstanceManager instanceManager;
    private final ClassLoader classLoader;
    private final Class[] interfaces;
    private final XAResourceWrapper xaResourceWrapper;
    protected final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
    private final Class<?> proxy;
    private final boolean usePool;

    public EndpointFactory(ActivationSpec activationSpec, BaseMdbContainer container, BeanContext beanContext, MdbInstanceFactory instanceFactory, MdbInstanceManager instanceManager, XAResourceWrapper xaResourceWrapper, boolean usePool) {
        this.activationSpec = activationSpec;
        this.container = container;
        this.beanContext = beanContext;
        this.instanceFactory = instanceFactory;
        this.instanceManager = instanceManager;
        this.classLoader = container.getMessageListenerInterface().getClassLoader();
        this.interfaces = new Class[]{container.getMessageListenerInterface(), MessageEndpoint.class};
        this.xaResourceWrapper = xaResourceWrapper;
        this.usePool = usePool;
        BeanContext.ProxyClass proxyClass = beanContext.get(BeanContext.ProxyClass.class);
        if (proxyClass == null) {
            this.proxy = LocalBeanProxyFactory.createProxy(beanContext.getBeanClass(), beanContext.getClassLoader(), this.interfaces);
            beanContext.set(BeanContext.ProxyClass.class, new BeanContext.ProxyClass(beanContext, this.interfaces));
        } else {
            this.proxy = proxyClass.getProxy();
        }
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public MdbInstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        if (xaResource != null && this.xaResourceWrapper != null) {
            xaResource = this.xaResourceWrapper.wrap(xaResource, this.container.getContainerID().toString());
        }
        AbstractEndpointHandler endpointHandler = null;
        endpointHandler = this.usePool ? new PoolEndpointHandler(this.container, this.beanContext, this.instanceManager, xaResource) : new EndpointHandler(this.container, this.beanContext, this.instanceFactory, xaResource);
        try {
            return (MessageEndpoint)LocalBeanProxyFactory.constructProxy(this.proxy, endpointHandler);
        }
        catch (InternalError e) {
            try {
                return (MessageEndpoint)MessageEndpoint.class.cast(LocalBeanProxyFactory.newProxyInstance(Thread.currentThread().getContextClassLoader(), endpointHandler, this.beanContext.getBeanClass(), this.interfaces));
            }
            catch (InternalError ie) {
                try {
                    return (MessageEndpoint)MessageEndpoint.class.cast(LocalBeanProxyFactory.newProxyInstance(this.classLoader, endpointHandler, this.beanContext.getBeanClass(), this.interfaces));
                }
                catch (InternalError internalError) {
                    throw e;
                }
            }
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        if (timeout <= 0L) {
            return this.createEndpoint(xaResource);
        }
        long end = System.currentTimeMillis() + timeout;
        MessageEndpoint messageEndpoint = null;
        while (System.currentTimeMillis() <= end) {
            try {
                messageEndpoint = this.createEndpoint(xaResource);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (messageEndpoint != null) {
            return messageEndpoint;
        }
        throw new UnavailableException("Unable to create end point within the specified timeout " + timeout);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        TransactionType transactionType = this.beanContext.getTransactionType(method);
        return TransactionType.Required == transactionType;
    }

    public String getActivationName() {
        return this.container.getContainerID().toString();
    }

    public Class<?> getEndpointClass() {
        return this.beanContext.getBeanClass();
    }
}

