/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.DateTimeExtractPart;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

class ExtractDateTimePart
extends Val {
    private static final long serialVersionUID = 1L;
    private final DateTimeExtractPart _part;
    private final Val _val;

    public ExtractDateTimePart(DateTimeExtractPart part, Val val) {
        this._part = part;
        this._val = val;
    }

    @Override
    public Class getType() {
        if (this._part == DateTimeExtractPart.TIME) {
            return Time.class;
        }
        if (this._part == DateTimeExtractPart.DATE) {
            return Date.class;
        }
        throw new IllegalStateException();
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object r = this._val.eval(candidate, orig, ctx, params);
        Class<?> clazz = r.getClass();
        if (this._part == DateTimeExtractPart.TIME) {
            if (Time.class.isAssignableFrom(clazz)) {
                return (Time)r;
            }
            if (Timestamp.class.isAssignableFrom(clazz)) {
                return Time.valueOf(((Timestamp)r).toLocalDateTime().toLocalTime());
            }
            if (LocalDateTime.class.isAssignableFrom(clazz)) {
                return Time.valueOf(((LocalDateTime)r).toLocalTime());
            }
            if (LocalTime.class.isAssignableFrom(clazz)) {
                return Time.valueOf((LocalTime)r);
            }
            if (Instant.class.isAssignableFrom(clazz)) {
                LocalDateTime ldt = LocalDateTime.ofInstant((Instant)r, ZoneId.systemDefault());
                return Time.valueOf(ldt.toLocalTime());
            }
        } else if (this._part == DateTimeExtractPart.DATE) {
            if (Date.class.isAssignableFrom(clazz)) {
                return (Date)r;
            }
            if (Timestamp.class.isAssignableFrom(clazz)) {
                return Date.valueOf(((Timestamp)r).toLocalDateTime().toLocalDate());
            }
            if (LocalDateTime.class.isAssignableFrom(clazz)) {
                return Date.valueOf(((LocalDateTime)r).toLocalDate());
            }
            if (LocalDate.class.isAssignableFrom(clazz)) {
                return Date.valueOf((LocalDate)r);
            }
            if (Instant.class.isAssignableFrom(clazz)) {
                LocalDateTime ldt = LocalDateTime.ofInstant((Instant)r, ZoneId.systemDefault());
                return Date.valueOf(ldt.toLocalDate());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

