/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.activemq.management.Resettable;
import org.apache.activemq.management.Statistic;
import org.apache.activemq.management.StatisticImpl;
import org.apache.activemq.management.Stats;

public class StatsImpl
extends StatisticImpl
implements Stats,
Resettable {
    protected final Set<StatisticImpl> set;

    public StatsImpl() {
        this(new CopyOnWriteArraySet<StatisticImpl>());
    }

    public StatsImpl(Set<StatisticImpl> set) {
        super("stats", "many", "Used only as container, not Statistic");
        this.set = set;
    }

    @Override
    public synchronized void reset() {
        this.set.stream().filter(Resettable.class::isInstance).map(Resettable.class::cast).forEach(resetStat -> resetStat.reset());
    }

    @Override
    public synchronized Statistic getStatistic(String name) {
        return this.set.stream().filter(s -> s.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public synchronized String[] getStatisticNames() {
        return (String[])this.set.stream().map(StatisticImpl::getName).toArray(String[]::new);
    }

    @Override
    public synchronized Statistic[] getStatistics() {
        return this.set.toArray(new Statistic[this.set.size()]);
    }

    @Deprecated(forRemoval=true, since="6.2.0")
    protected synchronized void addStatistic(String name, StatisticImpl statistic) {
        this.set.add(statistic);
    }

    protected void addStatistics(Collection<StatisticImpl> statistics) {
        this.set.addAll(statistics);
    }

    protected void removeStatistics(Collection<StatisticImpl> statistics) {
        this.set.removeAll(statistics);
    }
}

