/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class ScriptEngineCache {
    public static final String DEFAULT_SCRIPT_ENGINE = "gremlin-groovy";
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
    private static final Map<String, ScriptEngine> CACHED_ENGINES = new ConcurrentHashMap<String, ScriptEngine>();

    private ScriptEngineCache() {
    }

    public static ScriptEngine get(String engineName) {
        return CACHED_ENGINES.compute(engineName, (key, engine) -> {
            if (null == engine && null == (engine = SCRIPT_ENGINE_MANAGER.getEngineByName(engineName))) {
                throw new IllegalArgumentException("There is no script engine with provided name: " + engineName);
            }
            return engine;
        });
    }
}

