/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Flowable")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="flowable/userWorkflowTasks")
public interface UserWorkflowTaskService
extends JAXRSService {
    @GET
    @Path(value="tasks/{userKey}")
    @Produces(value={"application/json"})
    public List<WorkflowTask> getAvailableTasks(@NotNull @PathParam(value="userKey") String var1);

    @Parameter(name="userKey", description="user key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @POST
    @Path(value="tasks/{userKey}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public UserTO executeNextTask(@NotNull WorkflowTaskExecInput var1);
}

