/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.util.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSAML2MetadataSigner
implements SAML2MetadataSigner {
    protected final CredentialProvider credentialProvider;
    protected final String signatureAlgorithm;
    protected final String signatureReferenceDigestMethod;
    protected final SAML2Configuration configuration;

    public DefaultSAML2MetadataSigner(SAML2Configuration configuration) {
        this.configuration = configuration;
        this.credentialProvider = null;
        this.signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        this.signatureReferenceDigestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
    }

    public DefaultSAML2MetadataSigner(CredentialProvider credentialProvider, String signatureAlgorithm, String signatureReferenceDigestMethod) {
        this.configuration = null;
        this.credentialProvider = credentialProvider;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureReferenceDigestMethod = signatureReferenceDigestMethod;
    }

    private byte[] sign(byte[] metadata) throws Exception {
        try (ByteArrayInputStream is = new ByteArrayInputStream(metadata);){
            SignableXMLObject root;
            Document document = Configuration.getParserPool().parse((InputStream)is);
            Element documentElement = document.getDocumentElement();
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(documentElement);
            XMLObject xmlObject = Objects.requireNonNull(unmarshaller).unmarshall(documentElement);
            if (xmlObject instanceof SignableXMLObject && !(root = (SignableXMLObject)xmlObject).isSigned()) {
                this.sign(root);
                try (StringWriter writer = Configuration.serializeSamlObject((XMLObject)root);){
                    byte[] byArray = writer.toString().getBytes(StandardCharsets.UTF_8);
                    return byArray;
                }
            }
            byte[] byArray = metadata;
            return byArray;
        }
    }

    @Override
    public String sign(String metadata) {
        try {
            byte[] input = metadata.getBytes(StandardCharsets.UTF_8);
            byte[] result = this.sign(input);
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }

    @Override
    public void sign(File metadataFile) {
        try {
            byte[] input = Files.readAllBytes(metadataFile.toPath());
            byte[] result = this.sign(input);
            Files.writeString(metadataFile.toPath(), (CharSequence)new String(result, StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }

    @Override
    public void sign(SignableXMLObject descriptor) {
        try {
            SignatureSigningParameters signingParameters = new SignatureSigningParameters();
            CredentialProvider activeProvider = Objects.requireNonNull(Optional.ofNullable(this.configuration).map(SAML2Configuration::getCredentialProvider).orElse(this.credentialProvider));
            signingParameters.setKeyInfoGenerator(activeProvider.getKeyInfoGenerator());
            signingParameters.setSigningCredential(activeProvider.getCredential());
            String signingAlgorithm = Optional.ofNullable(this.configuration).map(SAML2Configuration::getSignatureAlgorithms).filter(algorithms -> !algorithms.isEmpty()).map(algorithms -> (String)algorithms.get(0)).orElse(this.signatureAlgorithm);
            signingParameters.setSignatureAlgorithm(signingAlgorithm);
            String signingReference = Optional.ofNullable(this.configuration).map(SAML2Configuration::getSignatureReferenceDigestMethods).filter(algorithms -> !algorithms.isEmpty()).map(algorithms -> (String)algorithms.get(0)).orElse(this.signatureReferenceDigestMethod);
            signingParameters.setSignatureReferenceDigestMethod(signingReference);
            signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            SignatureSupport.signObject((SignableXMLObject)descriptor, (SignatureSigningParameters)signingParameters);
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }
}

