/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConsumerExecutionAction
extends BaseCasWebflowAction {
    public static final Action NONE = new ConsumerExecutionAction(ctx -> {});
    public static final Action OK = new ConsumerExecutionAction(ctx -> {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)ctx);
        response.setStatus(HttpStatus.OK.value());
        ctx.getExternalContext().recordResponseComplete();
    });
    public static final Action NO_CONTENT = new ConsumerExecutionAction(ctx -> {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)ctx);
        response.setStatus(HttpStatus.NO_CONTENT.value());
        ctx.getExternalContext().recordResponseComplete();
    });
    public static final Action EVENT_ATTRIBUTES_TO_FLOW_SCOPE = new ConsumerExecutionAction(ctx -> {
        if (ctx.getCurrentEvent() != null) {
            ctx.getFlowScope().putAll(ctx.getCurrentEvent().getAttributes());
        }
    });
    private final Consumer<RequestContext> task;
    private String eventId;

    @Override
    public Event doExecuteInternal(RequestContext requestContext) {
        this.task.accept(requestContext);
        return StringUtils.isNotBlank((CharSequence)this.eventId) ? this.eventFactory.event((Object)this, this.eventId) : null;
    }

    public String toString() {
        return "InlineActionReturns%s".formatted(StringUtils.defaultIfBlank((CharSequence)this.eventId, (CharSequence)"None"));
    }

    public static Action wrap(Action innerAction) {
        return new ConsumerExecutionAction(Unchecked.consumer(arg_0 -> ((Action)innerAction).execute(arg_0)));
    }

    @Generated
    public ConsumerExecutionAction(Consumer<RequestContext> task) {
        this.task = task;
    }

    @Generated
    public ConsumerExecutionAction setEventId(String eventId) {
        this.eventId = eventId;
        return this;
    }
}

