/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.saml.util.Saml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlIdPResponseCustomizer;
import org.apereo.cas.util.CollectionUtils;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationSamlIdPResponseCustomizer
implements SamlIdPResponseCustomizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationSamlIdPResponseCustomizer.class);
    private final DelegatedIdentityProviders identityProviders;

    public void customizeAssertion(SamlProfileBuilderContext context, Saml20ObjectBuilder builder, Assertion assertion) {
        Map attributes = ((AuthenticatedAssertionContext)context.getAuthenticatedAssertion().orElseThrow()).getAttributes();
        LOGGER.debug("Attributes to evaluate to customize SAML2 assertion are [{}]", (Object)attributes);
        if (attributes.containsKey("clientName") && !context.getRegisteredService().isSkipGeneratingAuthenticatingAuthority()) {
            Set clientNames = CollectionUtils.toCollection(attributes.get("clientName"));
            JEEContext webContext = new JEEContext(Objects.requireNonNull(context.getHttpRequest()), Objects.requireNonNull(context.getHttpResponse()));
            clientNames.forEach(clientName -> this.identityProviders.findClient(clientName.toString(), (WebContext)webContext).filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).ifPresent(client -> {
                client.init();
                assertion.getAuthnStatements().forEach(authnStatement -> {
                    AuthnContext authnContext = authnStatement.getAuthnContext();
                    AuthenticatingAuthority authority = (AuthenticatingAuthority)builder.newSamlObject(AuthenticatingAuthority.class);
                    authority.setURI(client.getIdentityProviderResolvedEntityId());
                    LOGGER.debug("Customizing SAML2 assertion to include authenticating authority [{}] linked to delegated client [{}]", (Object)client.getIdentityProviderResolvedEntityId(), clientName);
                    authnContext.getAuthenticatingAuthorities().add(authority);
                });
            }));
        }
    }

    @Generated
    public DelegatedAuthenticationSamlIdPResponseCustomizer(DelegatedIdentityProviders identityProviders) {
        this.identityProviders = identityProviders;
    }
}

