/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wicket.ajax.markup.html.IndicatorAjaxLink;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobActionPanel
extends WizardMgtPanel<Serializable> {
    private static final long serialVersionUID = 6645135178773151224L;
    protected static final Logger LOG = LoggerFactory.getLogger(JobActionPanel.class);
    @SpringBean
    protected NotificationRestClient notificationRestClient;
    @SpringBean
    protected ReportRestClient reportRestClient;
    @SpringBean
    protected TaskRestClient taskRestClient;

    public JobActionPanel(String id, final JobTO jobTO, boolean showNotRunning, final Component container) {
        super(id, true);
        Fragment controls;
        this.setOutputMarkupId(true);
        if (jobTO.isRunning()) {
            controls = new Fragment("controls", "runningFragment", (MarkupContainer)this);
            controls.add(new Component[]{new Label("status", (IModel)Model.of()).add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Model.of((Serializable)((Object)("<pre>" + (jobTO.getStatus() == null ? "" : jobTO.getStatus()) + "</pre>"))), new PopoverConfig().withAnimation(true).withHoverTrigger().withHtml(true).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.left))})});
            controls.add(new Component[]{new IndicatorAjaxLink<Void>(this, "stop"){
                private static final long serialVersionUID = -7978723352517770644L;
                final /* synthetic */ JobActionPanel this$0;
                {
                    this.this$0 = this$0;
                    super(id);
                }

                public void onClick(AjaxRequestTarget target) {
                    try {
                        switch (jobTO.getType()) {
                            case NOTIFICATION: {
                                this.this$0.notificationRestClient.actionJob(JobAction.STOP);
                                break;
                            }
                            case REPORT: {
                                this.this$0.reportRestClient.actionJob(jobTO.getRefKey(), JobAction.STOP);
                                break;
                            }
                            case TASK: {
                                this.this$0.taskRestClient.actionJob(jobTO.getRefKey(), JobAction.STOP);
                                break;
                            }
                        }
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        this.send((IEventSink)container, Broadcast.EXACT, new JobActionPayload(target));
                    }
                    catch (Exception e) {
                        LOG.error("While stopping {}", (Object)jobTO.getRefDesc(), (Object)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }});
        } else {
            controls = new Fragment("controls", "notRunningFragment", (MarkupContainer)this);
            controls.add(new Component[]{new IndicatorAjaxLink<Void>(this, "start"){
                private static final long serialVersionUID = -7978723352517770644L;
                final /* synthetic */ JobActionPanel this$0;
                {
                    this.this$0 = this$0;
                    super(id);
                }

                public void onClick(AjaxRequestTarget target) {
                    try {
                        switch (jobTO.getType()) {
                            case NOTIFICATION: {
                                this.this$0.notificationRestClient.actionJob(JobAction.START);
                                break;
                            }
                            case REPORT: {
                                this.this$0.reportRestClient.actionJob(jobTO.getRefKey(), JobAction.START);
                                break;
                            }
                            case TASK: {
                                this.this$0.taskRestClient.actionJob(jobTO.getRefKey(), JobAction.START);
                                break;
                            }
                        }
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        this.send((IEventSink)container, Broadcast.EXACT, new JobActionPayload(target));
                    }
                    catch (Exception e) {
                        LOG.error("While starting {}", (Object)jobTO.getRefDesc(), (Object)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }});
            if (!showNotRunning) {
                controls.setOutputMarkupPlaceholderTag(true);
                controls.setVisible(false);
            }
        }
        this.addInnerObject(new Component[]{controls});
    }

    public static class JobActionPayload
    implements Serializable {
        private static final long serialVersionUID = -6798174303329212126L;
        private final AjaxRequestTarget target;

        public JobActionPayload(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

