/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.TenantUserInterfacePolicy;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.servlet.theme.AbstractThemeResolver;

public class TenantThemeResolver
extends AbstractThemeResolver {
    protected final ObjectProvider<TenantExtractor> tenantExtractor;
    protected final ObjectProvider<ServicesManager> servicesManager;
    protected final ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    protected final ObjectProvider<CasConfigurationProperties> casProperties;

    @Nonnull
    public String resolveThemeName(HttpServletRequest request) {
        return ((TenantExtractor)this.tenantExtractor.getObject()).extract(request).map(TenantDefinition::getUserInterfacePolicy).filter(policy -> StringUtils.isNotBlank((CharSequence)policy.getThemeName())).map(TenantUserInterfacePolicy::getThemeName).orElseGet(() -> ((TenantThemeResolver)this).getDefaultThemeName());
    }

    @Generated
    public TenantThemeResolver(ObjectProvider<TenantExtractor> tenantExtractor, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies, ObjectProvider<CasConfigurationProperties> casProperties) {
        this.tenantExtractor = tenantExtractor;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.casProperties = casProperties;
    }
}

