/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.hibernate;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class CasHibernatePhysicalNamingStrategy
extends CamelCaseToUnderscoresNamingStrategy
implements ApplicationContextAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasHibernatePhysicalNamingStrategy.class);

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        Optional propsResult = ApplicationContextProvider.getCasConfigurationProperties();
        if (propsResult.isEmpty()) {
            LOGGER.error("Could not load configuration settings. CAS application context may not have initialized correctly.");
            return super.toPhysicalTableName(name, jdbcEnvironment);
        }
        String tableName = name.getCanonicalName();
        CasConfigurationProperties casProperties = (CasConfigurationProperties)propsResult.get();
        Map tableNames = casProperties.getJdbc().getPhysicalTableNames();
        if (tableNames.isEmpty()) {
            LOGGER.trace("No configured table names are defined to map [{}]", (Object)tableName);
            return super.toPhysicalTableName(name, jdbcEnvironment);
        }
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        LOGGER.trace("Locating physical table name for [{}] based on configured table names [{}]", (Object)tableName, (Object)tableNames);
        if (tableNames.containsKey(tableName)) {
            String physicalName = (String)tableNames.get(tableName);
            Optional scriptFactoryInstance = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
            if (scriptFactoryInstance.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).isExternalScript(physicalName)) {
                LOGGER.trace("Executing script [{}] to determine physical table name for [{}]", (Object)physicalName, (Object)tableName);
                return (Identifier)FunctionUtils.doUnchecked(() -> {
                    Resource scriptResource = applicationContext.getResource(physicalName);
                    Object[] args = new Object[]{name, jdbcEnvironment, applicationContext, LOGGER};
                    ExecutableCompiledScript script = ((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).fromResource(scriptResource);
                    Identifier identifier = (Identifier)script.execute(args, Identifier.class, true);
                    LOGGER.trace("Determine table physical name from script [{}] to be [{}]", (Object)scriptResource, (Object)identifier);
                    return identifier;
                });
            }
            LOGGER.trace("Located physical table name [{}] for [{}]", (Object)physicalName, (Object)tableName);
            return Identifier.toIdentifier((String)physicalName);
        }
        return super.toPhysicalTableName(name, jdbcEnvironment);
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        ApplicationContextProvider.holdApplicationContext((ApplicationContext)applicationContext);
    }

    protected boolean isCaseInsensitive(JdbcEnvironment jdbcEnvironment) {
        Optional propsResult = ApplicationContextProvider.getCasConfigurationProperties();
        if (propsResult.isEmpty()) {
            LOGGER.debug("Could not load configuration settings to determine case insensitivity.");
            return super.isCaseInsensitive(jdbcEnvironment);
        }
        CasConfigurationProperties casProperties = (CasConfigurationProperties)propsResult.get();
        return casProperties.getJdbc().isCaseInsensitive();
    }
}

