/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.DecodableCipherExecutorMapModule;
import org.apereo.cas.util.serialization.JacksonInjectableValueSupplier;
import org.apereo.cas.util.serialization.JacksonObjectMapperCustomizer;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class JacksonObjectMapperFactory {
    private final boolean defaultTypingEnabled;
    private final boolean failOnUnknownProperties;
    private final boolean singleValueAsArray;
    private final boolean singleArrayElementUnwrapped;
    private final boolean writeDatesAsTimestamps;
    private final boolean defaultViewInclusion;
    private final boolean quoteFieldNames;
    private final boolean useWrapperNameAsProperty;
    private final Map<String, Object> injectableValues;
    private final boolean minimal;
    private final boolean sorted;
    private final JsonFactory jsonFactory;
    private final ConfigurableApplicationContext applicationContext;

    public ObjectMapper toObjectMapper() {
        MapperBuilder<?, ?> mapper = this.determineMapperInstance();
        ObjectMapper objectMapper = this.initialize(mapper);
        List<JacksonObjectMapperCustomizer> allCustomizers = this.getObjectMapperCustomizers();
        this.configureInjectableValues(allCustomizers, objectMapper);
        this.configureObjectMapperModules(objectMapper);
        allCustomizers.forEach(customizer -> customizer.customize(objectMapper));
        return objectMapper;
    }

    private void configureObjectMapperModules(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new JavaTimeModule());
        if (this.applicationContext != null) {
            objectMapper.registerModule((Module)new DecodableCipherExecutorMapModule((ApplicationContext)this.applicationContext));
        }
    }

    private void configureInjectableValues(List<JacksonObjectMapperCustomizer> allCustomizers, ObjectMapper objectMapper) {
        Map<String, Object> injectedValues = allCustomizers.stream().filter(BeanSupplier::isNotProxy).map(JacksonObjectMapperCustomizer::getInjectableValues).flatMap(entry -> entry.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        injectedValues.putAll(this.injectableValues);
        objectMapper.setInjectableValues((InjectableValues)new JacksonInjectableValueSupplier(() -> injectedValues));
    }

    private List<JacksonObjectMapperCustomizer> getObjectMapperCustomizers() {
        List<JacksonObjectMapperCustomizer> customizers = ServiceLoader.load(JacksonObjectMapperCustomizer.class).stream().map(ServiceLoader.Provider::get).filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
        ApplicationContext effectiveContext = (ApplicationContext)ObjectUtils.getIfNull((Object)this.applicationContext, (Object)ApplicationContextProvider.getApplicationContext());
        if (effectiveContext != null) {
            Collection customizerBeans = effectiveContext.getBeansOfType(JacksonObjectMapperCustomizer.class).values();
            customizers.addAll(customizerBeans);
        }
        AnnotationAwareOrderComparator.sort(customizers);
        return customizers;
    }

    protected ObjectMapper initialize(MapperBuilder<?, ?> mapper) {
        ObjectMapper obm = mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, this.isSingleArrayElementUnwrapped()).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, this.isDefaultViewInclusion()).configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, this.isUseWrapperNameAsProperty()).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, this.sorted).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, this.sorted).configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), this.isQuoteFieldNames()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.isFailOnUnknownProperties()).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, this.isSingleValueAsArray()).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, this.isQuoteFieldNames()).disable(new DeserializationFeature[]{DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE}).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, this.isWriteDatesAsTimestamps()).build();
        obm.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC).findAndRegisterModules().registerModule(JacksonObjectMapperFactory.getCasJacksonModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule());
        if (this.isDefaultTypingEnabled()) {
            obm.activateDefaultTyping(obm.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
        if (this.minimal) {
            obm.setDefaultPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter());
        }
        return obm;
    }

    private MapperBuilder<?, ?> determineMapperInstance() {
        JsonFactory jsonFactory = this.jsonFactory;
        if (jsonFactory instanceof YAMLFactory) {
            YAMLFactory factory = (YAMLFactory)jsonFactory;
            return YAMLMapper.builder((YAMLFactory)factory);
        }
        jsonFactory = this.jsonFactory;
        if (jsonFactory instanceof XmlFactory) {
            XmlFactory factory = (XmlFactory)jsonFactory;
            return XmlMapper.builder((XmlFactory)factory);
        }
        return JsonMapper.builder((JsonFactory)this.jsonFactory);
    }

    private static Module getCasJacksonModule() {
        SimpleModule casModule = new SimpleModule();
        casModule.addDeserializer(URI.class, (JsonDeserializer)new URIDeserializer());
        return casModule;
    }

    @Generated
    private static boolean $default$defaultViewInclusion() {
        return true;
    }

    @Generated
    private static boolean $default$quoteFieldNames() {
        return true;
    }

    @Generated
    private static boolean $default$useWrapperNameAsProperty() {
        return false;
    }

    @Generated
    private static Map<String, Object> $default$injectableValues() {
        return new LinkedHashMap<String, Object>();
    }

    @Generated
    private static boolean $default$minimal() {
        return false;
    }

    @Generated
    private static boolean $default$sorted() {
        return false;
    }

    @Generated
    protected JacksonObjectMapperFactory(JacksonObjectMapperFactoryBuilder<?, ?> b) {
        this.defaultTypingEnabled = b.defaultTypingEnabled;
        this.failOnUnknownProperties = b.failOnUnknownProperties;
        this.singleValueAsArray = b.singleValueAsArray;
        this.singleArrayElementUnwrapped = b.singleArrayElementUnwrapped;
        this.writeDatesAsTimestamps = b.writeDatesAsTimestamps;
        this.defaultViewInclusion = b.defaultViewInclusion$set ? b.defaultViewInclusion$value : JacksonObjectMapperFactory.$default$defaultViewInclusion();
        this.quoteFieldNames = b.quoteFieldNames$set ? b.quoteFieldNames$value : JacksonObjectMapperFactory.$default$quoteFieldNames();
        this.useWrapperNameAsProperty = b.useWrapperNameAsProperty$set ? b.useWrapperNameAsProperty$value : JacksonObjectMapperFactory.$default$useWrapperNameAsProperty();
        this.injectableValues = b.injectableValues$set ? b.injectableValues$value : JacksonObjectMapperFactory.$default$injectableValues();
        this.minimal = b.minimal$set ? b.minimal$value : JacksonObjectMapperFactory.$default$minimal();
        this.sorted = b.sorted$set ? b.sorted$value : JacksonObjectMapperFactory.$default$sorted();
        this.jsonFactory = b.jsonFactory;
        this.applicationContext = b.applicationContext;
    }

    @Generated
    public static JacksonObjectMapperFactoryBuilder<?, ?> builder() {
        return new JacksonObjectMapperFactoryBuilderImpl();
    }

    @Generated
    public boolean isDefaultTypingEnabled() {
        return this.defaultTypingEnabled;
    }

    @Generated
    public boolean isFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    @Generated
    public boolean isSingleValueAsArray() {
        return this.singleValueAsArray;
    }

    @Generated
    public boolean isSingleArrayElementUnwrapped() {
        return this.singleArrayElementUnwrapped;
    }

    @Generated
    public boolean isWriteDatesAsTimestamps() {
        return this.writeDatesAsTimestamps;
    }

    @Generated
    public boolean isDefaultViewInclusion() {
        return this.defaultViewInclusion;
    }

    @Generated
    public boolean isQuoteFieldNames() {
        return this.quoteFieldNames;
    }

    @Generated
    public boolean isUseWrapperNameAsProperty() {
        return this.useWrapperNameAsProperty;
    }

    @Generated
    public Map<String, Object> getInjectableValues() {
        return this.injectableValues;
    }

    @Generated
    public boolean isMinimal() {
        return this.minimal;
    }

    @Generated
    public boolean isSorted() {
        return this.sorted;
    }

    @Generated
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private static final class URIDeserializer
    extends StdDeserializer<URI> {
        private static final long serialVersionUID = -7547162569192932415L;

        URIDeserializer() {
            this(null);
        }

        URIDeserializer(Class<?> vc) {
            super(vc);
        }

        public URI deserialize(JsonParser jp, DeserializationContext ctxt) {
            return (URI)FunctionUtils.doUnchecked(() -> {
                String value = SpringExpressionLanguageValueResolver.getInstance().resolve(jp.getText().trim());
                return StringUtils.isNotBlank((CharSequence)value) ? new URI(value) : null;
            });
        }
    }

    @Generated
    public static abstract class JacksonObjectMapperFactoryBuilder<C extends JacksonObjectMapperFactory, B extends JacksonObjectMapperFactoryBuilder<C, B>> {
        @Generated
        private boolean defaultTypingEnabled;
        @Generated
        private boolean failOnUnknownProperties;
        @Generated
        private boolean singleValueAsArray;
        @Generated
        private boolean singleArrayElementUnwrapped;
        @Generated
        private boolean writeDatesAsTimestamps;
        @Generated
        private boolean defaultViewInclusion$set;
        @Generated
        private boolean defaultViewInclusion$value;
        @Generated
        private boolean quoteFieldNames$set;
        @Generated
        private boolean quoteFieldNames$value;
        @Generated
        private boolean useWrapperNameAsProperty$set;
        @Generated
        private boolean useWrapperNameAsProperty$value;
        @Generated
        private boolean injectableValues$set;
        @Generated
        private Map<String, Object> injectableValues$value;
        @Generated
        private boolean minimal$set;
        @Generated
        private boolean minimal$value;
        @Generated
        private boolean sorted$set;
        @Generated
        private boolean sorted$value;
        @Generated
        private JsonFactory jsonFactory;
        @Generated
        private ConfigurableApplicationContext applicationContext;

        @Generated
        public B defaultTypingEnabled(boolean defaultTypingEnabled) {
            this.defaultTypingEnabled = defaultTypingEnabled;
            return this.self();
        }

        @Generated
        public B failOnUnknownProperties(boolean failOnUnknownProperties) {
            this.failOnUnknownProperties = failOnUnknownProperties;
            return this.self();
        }

        @Generated
        public B singleValueAsArray(boolean singleValueAsArray) {
            this.singleValueAsArray = singleValueAsArray;
            return this.self();
        }

        @Generated
        public B singleArrayElementUnwrapped(boolean singleArrayElementUnwrapped) {
            this.singleArrayElementUnwrapped = singleArrayElementUnwrapped;
            return this.self();
        }

        @Generated
        public B writeDatesAsTimestamps(boolean writeDatesAsTimestamps) {
            this.writeDatesAsTimestamps = writeDatesAsTimestamps;
            return this.self();
        }

        @Generated
        public B defaultViewInclusion(boolean defaultViewInclusion) {
            this.defaultViewInclusion$value = defaultViewInclusion;
            this.defaultViewInclusion$set = true;
            return this.self();
        }

        @Generated
        public B quoteFieldNames(boolean quoteFieldNames) {
            this.quoteFieldNames$value = quoteFieldNames;
            this.quoteFieldNames$set = true;
            return this.self();
        }

        @Generated
        public B useWrapperNameAsProperty(boolean useWrapperNameAsProperty) {
            this.useWrapperNameAsProperty$value = useWrapperNameAsProperty;
            this.useWrapperNameAsProperty$set = true;
            return this.self();
        }

        @Generated
        public B injectableValues(Map<String, Object> injectableValues) {
            this.injectableValues$value = injectableValues;
            this.injectableValues$set = true;
            return this.self();
        }

        @Generated
        public B minimal(boolean minimal) {
            this.minimal$value = minimal;
            this.minimal$set = true;
            return this.self();
        }

        @Generated
        public B sorted(boolean sorted) {
            this.sorted$value = sorted;
            this.sorted$set = true;
            return this.self();
        }

        @Generated
        public B jsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this.self();
        }

        @Generated
        public B applicationContext(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder(defaultTypingEnabled=" + this.defaultTypingEnabled + ", failOnUnknownProperties=" + this.failOnUnknownProperties + ", singleValueAsArray=" + this.singleValueAsArray + ", singleArrayElementUnwrapped=" + this.singleArrayElementUnwrapped + ", writeDatesAsTimestamps=" + this.writeDatesAsTimestamps + ", defaultViewInclusion$value=" + this.defaultViewInclusion$value + ", quoteFieldNames$value=" + this.quoteFieldNames$value + ", useWrapperNameAsProperty$value=" + this.useWrapperNameAsProperty$value + ", injectableValues$value=" + String.valueOf(this.injectableValues$value) + ", minimal$value=" + this.minimal$value + ", sorted$value=" + this.sorted$value + ", jsonFactory=" + String.valueOf(this.jsonFactory) + ", applicationContext=" + String.valueOf(this.applicationContext) + ")";
        }
    }

    @Generated
    private static final class JacksonObjectMapperFactoryBuilderImpl
    extends JacksonObjectMapperFactoryBuilder<JacksonObjectMapperFactory, JacksonObjectMapperFactoryBuilderImpl> {
        @Generated
        private JacksonObjectMapperFactoryBuilderImpl() {
        }

        @Override
        @Generated
        protected JacksonObjectMapperFactoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public JacksonObjectMapperFactory build() {
            return new JacksonObjectMapperFactory(this);
        }
    }
}

