/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.jca.JCAAware;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.integration.CacheLoader;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSEntraAccessTokenJWSVerifier
implements JWSVerifier {
    protected static final Logger LOG = LoggerFactory.getLogger(MSEntraAccessTokenJWSVerifier.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final Cache<String, JWSVerifier> verifiersCache;

    public MSEntraAccessTokenJWSVerifier(CacheManager cacheManager, CacheLoader<String, JWSVerifier> cacheLoader, Duration cacheExpireAfterWrite) {
        this.verifiersCache = cacheManager.createCache(SecureRandomUtils.generateRandomUUID().toString(), (Configuration)new MutableConfiguration().setTypes(String.class, JWSVerifier.class).setStoreByValue(false).setReadThrough(true).setCacheLoaderFactory((Factory)new FactoryBuilder.SingletonFactory(cacheLoader)).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)cacheExpireAfterWrite)));
    }

    protected Stream<JWSVerifier> getAllFromCache() {
        this.verifiersCache.getAll(Set.of(""));
        return StreamSupport.stream(this.verifiersCache.spliterator(), false).map(Cache.Entry::getValue);
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.getAllFromCache().flatMap(jwsVerifier -> jwsVerifier.supportedJWSAlgorithms().stream()).collect(Collectors.toSet());
    }

    public JCAContext getJCAContext() {
        return this.getAllFromCache().map(JCAAware::getJCAContext).findFirst().orElseThrow(() -> new IllegalStateException("JSON Web Key Set cache for Microsoft Entra is empty"));
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        String keyId = header.getKeyID();
        JWSVerifier delegate = Optional.ofNullable((JWSVerifier)this.verifiersCache.get((Object)keyId)).orElseThrow(() -> new JOSEException(String.format("JSON Web Key Set cache could not retrieve a public key for given key id '%s'", keyId)));
        return delegate.verify(header, signingInput, signature);
    }
}

