/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.context.condition;

import com.giffing.wicket.spring.boot.context.condition.ConditionalOnWicket;
import java.util.Map;
import org.apache.wicket.settings.FrameworkSettings;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class WicketSettingsCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String wicketVersion = this.retrieveWicketVersion();
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnWicket.class.getName());
        ConditionalOnWicket.Range range = (ConditionalOnWicket.Range)((Object)attributes.get("range"));
        int expectedVersion = (Integer)attributes.get("value");
        String[] splittedWicketVersion = wicketVersion.split("\\.");
        int majorWicketVersion = Integer.parseInt(splittedWicketVersion[0]);
        return this.getMatchOutcome(range, majorWicketVersion, expectedVersion);
    }

    protected ConditionOutcome getMatchOutcome(ConditionalOnWicket.Range range, int runningVersion, int expectedVersion) {
        boolean match = this.matches(range, expectedVersion, runningVersion);
        return new ConditionOutcome(match, this.getMessage(match, range, runningVersion, expectedVersion));
    }

    private boolean matches(ConditionalOnWicket.Range range, int expectedVersion, int runningVersion) {
        return switch (range) {
            default -> throw new IncompatibleClassChangeError();
            case ConditionalOnWicket.Range.EQUALS -> {
                if (runningVersion == expectedVersion) {
                    yield true;
                }
                yield false;
            }
            case ConditionalOnWicket.Range.EQUALS_OR_LOWER -> {
                if (runningVersion <= expectedVersion) {
                    yield true;
                }
                yield false;
            }
            case ConditionalOnWicket.Range.EQUALS_OR_HIGHER -> runningVersion >= expectedVersion;
        };
    }

    private String getMessage(boolean matches, ConditionalOnWicket.Range range, int runningVersion, int expectedVersion) {
        if (matches) {
            return "Wicket version matches current: " + runningVersion + " " + String.valueOf((Object)range) + " expected: " + expectedVersion;
        }
        return "Wicket version does not match current: " + runningVersion + " " + String.valueOf((Object)range) + " expected: " + expectedVersion;
    }

    private String retrieveWicketVersion() {
        String implVersion = null;
        Package pkg = FrameworkSettings.class.getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        return StringUtils.hasLength(implVersion) ? implVersion : "0";
    }
}

