/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.rest.DuoSecurityRestHttpRequestCredentialFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.plan.RestHttpRequestCredentialFactoryConfigurer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
@ConditionalOnClass(value={RestHttpRequestCredentialFactoryConfigurer.class})
@Configuration(value="DuoSecurityRestConfiguration", proxyBeanMethods=false)
class DuoSecurityRestConfiguration {
    DuoSecurityRestConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"duoSecurityRestHttpRequestCredentialFactoryConfigurer"})
    public RestHttpRequestCredentialFactoryConfigurer duoSecurityRestHttpRequestCredentialFactoryConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="duoSecurityRestHttpRequestCredentialFactory") RestHttpRequestCredentialFactory duoSecurityRestHttpRequestCredentialFactory) {
        return (RestHttpRequestCredentialFactoryConfigurer)BeanSupplier.of(RestHttpRequestCredentialFactoryConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> factory -> factory.registerCredentialFactory(duoSecurityRestHttpRequestCredentialFactory)).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"duoSecurityRestHttpRequestCredentialFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RestHttpRequestCredentialFactory duoSecurityRestHttpRequestCredentialFactory(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext) {
        return (RestHttpRequestCredentialFactory)BeanSupplier.of(RestHttpRequestCredentialFactory.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityRestHttpRequestCredentialFactory(tenantExtractor)).otherwiseProxy().get();
    }
}

