/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.TenantPersonAttributeDaoBuilder;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.TenantLdapPersonAttributeDaoBuilder;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnClass(value={LdapConnectionFactory.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasPersonDirectoryLdapConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryLdapConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryLdapConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.ldap[0].ldap-url");

    CasPersonDirectoryLdapConfiguration() {
    }

    @Configuration(value="LdapAttributeRepositoryMultitenancyConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class LdapAttributeRepositoryMultitenancyConfiguration {
        LdapAttributeRepositoryMultitenancyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ldapTenantPersonAttributeDaoBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TenantPersonAttributeDaoBuilder ldapTenantPersonAttributeDaoBuilder(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (TenantPersonAttributeDaoBuilder)BeanSupplier.of(TenantPersonAttributeDaoBuilder.class).when(BeanCondition.on((String)"cas.multitenancy.core.enabled").isTrue().given((ApplicationContext)applicationContext)).supply(TenantLdapPersonAttributeDaoBuilder::new).otherwise(TenantPersonAttributeDaoBuilder::noOp).get();
        }
    }

    @Configuration(value="LdapAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class LdapAttributeRepositoryPlanConfiguration {
        LdapAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"ldapPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer ldapPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="ldapAttributeRepositories") BeanContainer<PersonAttributeDao> ldapAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = ldapAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="LdapAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class LdapAttributeRepositoryConfiguration {
        LdapAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ldapAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> ldapAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                PrincipalAttributesProperties attrs = casProperties.getAuthn().getAttributeRepository();
                List list = LdapUtils.newPersonAttributeDaos((List)attrs.getLdap());
                return BeanContainer.of((List)list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

