/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import java.util.Arrays;

class CircularCountHolder {
    private final long[] counts;
    private final int length;
    private int startIndex;
    private int endIndex;
    private int baseIndex;

    CircularCountHolder(int size) {
        this.length = size;
        this.counts = new long[size];
        this.baseIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    long getValueAtIndex(int index) {
        return this.counts[this.getRelativeIndex(index)];
    }

    boolean isEmpty() {
        return this.baseIndex == Integer.MIN_VALUE;
    }

    boolean increment(int index, long incrementBy) {
        if (this.baseIndex == Integer.MIN_VALUE) {
            this.baseIndex = index;
            this.startIndex = index;
            this.endIndex = index;
            this.counts[0] = this.counts[0] + incrementBy;
            return true;
        }
        if (index > this.endIndex) {
            if ((long)index - (long)this.startIndex + 1L > (long)this.length) {
                return false;
            }
            this.endIndex = index;
        } else if (index < this.startIndex) {
            if ((long)this.endIndex - (long)index + 1L > (long)this.length) {
                return false;
            }
            this.startIndex = index;
        }
        int relativeIndex = this.getRelativeIndex(index);
        this.counts[relativeIndex] = this.counts[relativeIndex] + incrementBy;
        return true;
    }

    private int getRelativeIndex(int index) {
        int result = index - this.baseIndex;
        if (result >= this.length) {
            result -= this.length;
        } else if (result < 0) {
            result += this.length;
        }
        return result;
    }

    void reset() {
        Arrays.fill(this.counts, 0L);
        this.baseIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
    }
}

