/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientSessionManager;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowStateContributor;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.execution.RequestContext;

public class DefaultDelegatedClientAuthenticationWebflowManager
implements DelegatedClientAuthenticationWebflowManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientAuthenticationWebflowManager.class);
    private static final String CAS_CLIENT_ID_SESSION_KEY = "CAS_CLIENT_ID";
    private final DelegatedClientAuthenticationConfigurationContext configContext;

    public TransientSessionTicket store(RequestContext requestContext, JEEContext webContext, Client client) throws Throwable {
        TransientSessionTicket ticket = this.storeDelegatedClientAuthenticationRequest(webContext, requestContext, client);
        this.rememberSelectedClientIfNecessary(webContext, client);
        if (client instanceof CasClient) {
            CasClient instance = (CasClient)client;
            this.trackSessionIdForCasClient((WebContext)webContext, ticket, instance);
        } else {
            List<DelegatedClientSessionManager> builders = this.getDelegatedClientSessionManagers(client);
            builders.parallelStream().forEach(builder -> builder.trackIdentifier((WebContext)webContext, ticket, client));
        }
        return ticket;
    }

    public Service retrieve(RequestContext requestContext, WebContext webContext, Client client) {
        String clientId = this.getDelegatedClientId(webContext, client);
        Optional<TransientSessionTicket> ticket = this.retrieveSessionTicketViaClientId(webContext, clientId);
        Service service = this.restoreDelegatedAuthenticationRequest(requestContext, webContext, ticket, client);
        ticket.ifPresent(Unchecked.consumer(t -> {
            LOGGER.debug("Removing delegated client identifier [{}] from registry", (Object)t.getId());
            this.configContext.getTicketRegistry().deleteTicket(t.getId());
        }));
        return service;
    }

    protected void trackSessionIdForCasClient(WebContext webContext, TransientSessionTicket ticket, CasClient casClient) {
        this.configContext.getSessionStore().set(webContext, CAS_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected TransientSessionTicket storeDelegatedClientAuthenticationRequest(JEEContext webContext, RequestContext requestContext, Client client) throws Throwable {
        WebApplicationService originalService = Optional.ofNullable(this.configContext.getArgumentExtractor().extractService(webContext.getNativeRequest())).orElseGet(() -> WebUtils.getService((RequestContext)requestContext));
        LinkedHashMap properties = new LinkedHashMap();
        this.getWebflowStateContributors().forEach(Unchecked.consumer(contributor -> properties.putAll(contributor.store(requestContext, (WebContext)webContext, client))));
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.configContext.getTicketFactory().get(TransientSessionTicket.class);
        TransientSessionTicket ticket = transientFactory.create((Service)originalService, properties);
        LOGGER.debug("Storing delegated authentication request ticket [{}] for service [{}] with properties [{}]", new Object[]{ticket.getId(), ticket.getService(), ticket.getProperties()});
        this.configContext.getTicketRegistry().addTicket((Ticket)ticket);
        webContext.setRequestAttribute("delegatedclientid", (Object)ticket.getId());
        if (properties.containsKey("ForceAuthn")) {
            webContext.setRequestAttribute("ForceAuthn", (Object)true);
        }
        if (properties.containsKey("Passive")) {
            webContext.setRequestAttribute("Passive", (Object)true);
        }
        return ticket;
    }

    private List<DelegatedClientAuthenticationWebflowStateContributor> getWebflowStateContributors() {
        return this.configContext.getApplicationContext().getBeansOfType(DelegatedClientAuthenticationWebflowStateContributor.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<DelegatedClientAuthenticationWebflowStateContributor>)AnnotationAwareOrderComparator.INSTANCE).collect(Collectors.toList());
    }

    private List<DelegatedClientSessionManager> getDelegatedClientSessionManagers(Client client) {
        ArrayList<DelegatedClientSessionManager> builders = new ArrayList<DelegatedClientSessionManager>(this.configContext.getApplicationContext().getBeansOfType(DelegatedClientSessionManager.class).values().stream().filter(builder -> builder.supports(client)).toList());
        AnnotationAwareOrderComparator.sort(builders);
        return builders;
    }

    protected void rememberSelectedClientIfNecessary(JEEContext webContext, Client client) {
        Pac4jDelegatedAuthenticationCookieProperties cookieProps = this.configContext.getCasProperties().getAuthn().getPac4j().getCookie();
        if (cookieProps.isEnabled()) {
            CasCookieBuilder cookieBuilder = this.configContext.getDelegatedClientCookieGenerator();
            if (cookieProps.isAutoConfigureCookiePath()) {
                CookieUtils.configureCookiePath((HttpServletRequest)webContext.getNativeRequest(), (CasCookieBuilder)cookieBuilder);
            }
            cookieBuilder.addCookie(webContext.getNativeRequest(), webContext.getNativeResponse(), client.getName());
        }
    }

    protected Service restoreDelegatedAuthenticationRequest(RequestContext requestContext, WebContext webContext, Optional<TransientSessionTicket> ticket, Client client) {
        this.getWebflowStateContributors().forEach(Unchecked.consumer(contrib -> contrib.restore(requestContext, webContext, ticket, client)));
        return ticket.map(ServiceAwareTicket::getService).orElseGet(() -> {
            JEEContext context = (JEEContext)webContext;
            return this.configContext.getArgumentExtractor().extractService(context.getNativeRequest());
        });
    }

    protected Optional<TransientSessionTicket> retrieveSessionTicketViaClientId(WebContext webContext, String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId) || !clientId.startsWith("TST")) {
            LOGGER.info("Delegated client identifier [{}] is undefined in request URL [{}]", (Object)clientId, (Object)webContext.getFullRequestURL());
            return Optional.empty();
        }
        return (Optional)FunctionUtils.doAndHandle(() -> {
            TransientSessionTicket ticket = (TransientSessionTicket)this.configContext.getTicketRegistry().getTicket(clientId, TransientSessionTicket.class);
            LOGGER.debug("Located delegated authentication client identifier as [{}]", (Object)ticket.getId());
            return Optional.of(ticket);
        }, e -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw UnauthorizedServiceException.denied((String)"Rejected: %s".formatted(clientId));
        }).get();
    }

    protected String getDelegatedClientId(WebContext webContext, Client client) {
        String clientId = webContext.getRequestParameter("delegatedclientid").map(String::valueOf).orElse("");
        if (StringUtils.isBlank((CharSequence)(clientId = this.getDelegatedClientIdFromSessionStore(webContext, client, clientId, CasClient.class, CAS_CLIENT_ID_SESSION_KEY))) && client != null) {
            List<DelegatedClientSessionManager> builders = this.getDelegatedClientSessionManagers(client);
            Iterator<DelegatedClientSessionManager> iterator = builders.iterator();
            while (StringUtils.isBlank((CharSequence)clientId) && iterator.hasNext()) {
                DelegatedClientSessionManager builder = iterator.next();
                clientId = builder.retrieveIdentifier(webContext, client);
            }
        }
        LOGGER.debug("Located delegated client identifier [{}]", (Object)clientId);
        return clientId;
    }

    protected String getDelegatedClientIdFromSessionStore(WebContext webContext, Client client, String clientId, Class clientClass, String key) {
        if (StringUtils.isBlank((CharSequence)clientId) && client != null && clientClass.isAssignableFrom(client.getClass())) {
            LOGGER.debug("Client identifier could not be found in request parameters. Looking at session store for the [{}] client", (Object)clientClass);
            String newClientId = this.configContext.getSessionStore().get(webContext, key).map(Object::toString).orElse("");
            this.configContext.getSessionStore().set(webContext, key, null);
            return newClientId;
        }
        return clientId;
    }

    @Generated
    public DefaultDelegatedClientAuthenticationWebflowManager(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigContext() {
        return this.configContext;
    }
}

