/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseDelegatedClientAuthenticationCredentialResolver
implements DelegatedClientAuthenticationCredentialResolver {
    protected final DelegatedClientAuthenticationConfigurationContext configContext;

    public boolean supports(ClientCredential credentials) {
        return credentials != null;
    }

    protected Optional<UserProfile> resolveUserProfile(RequestContext requestContext, ClientCredential credentials) {
        return Optional.ofNullable(credentials.getUserProfile()).or(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            JEEContext webContext = new JEEContext(request, response);
            Client client = (Client)this.configContext.getIdentityProviders().findClient(credentials.getClientName(), (WebContext)webContext).orElseThrow(() -> new IllegalArgumentException("Unable to locate client"));
            CallContext callContext = new CallContext((WebContext)webContext, this.configContext.getSessionStore());
            return client.getUserProfile(callContext, credentials.getCredentials());
        });
    }

    @Generated
    public BaseDelegatedClientAuthenticationCredentialResolver(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

