/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.FlowableScriptEngine;
import org.flowable.common.engine.impl.scripting.FlowableScriptEvaluationRequest;
import org.flowable.common.engine.impl.scripting.FlowableScriptException;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.common.engine.impl.scripting.ScriptBindings;
import org.flowable.common.engine.impl.scripting.ScriptEvaluation;
import org.flowable.common.engine.impl.scripting.ScriptEvaluationImpl;

public class JSR223FlowableScriptEngine
implements FlowableScriptEngine {
    private final ScriptEngineManager scriptEngineManager;
    protected boolean cacheScriptingEngines = true;
    protected Map<String, ScriptEngine> cachedEngines;

    public JSR223FlowableScriptEngine() {
        this(new ScriptEngineManager());
    }

    public JSR223FlowableScriptEngine(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
        this.cachedEngines = new HashMap<String, ScriptEngine>();
    }

    @Override
    public FlowableScriptEvaluationRequest createEvaluationRequest() {
        return new JavaScriptingFlowableScriptEvaluationRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine getEngineByName(String language) {
        ScriptEngine scriptEngine = null;
        if (this.cacheScriptingEngines) {
            scriptEngine = this.cachedEngines.get(language);
            if (scriptEngine == null) {
                ScriptEngineManager scriptEngineManager = this.scriptEngineManager;
                synchronized (scriptEngineManager) {
                    scriptEngine = this.cachedEngines.get(language);
                    if (scriptEngine != null) {
                        return scriptEngine;
                    }
                    scriptEngine = this.scriptEngineManager.getEngineByName(language);
                    if (scriptEngine != null) {
                        Object threadingParameter;
                        if ("groovy".equals(language)) {
                            try {
                                scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((threadingParameter = scriptEngine.getFactory().getParameter("THREADING")) != null) {
                            this.cachedEngines.put(language, scriptEngine);
                        }
                    }
                }
            }
        } else {
            scriptEngine = this.scriptEngineManager.getEngineByName(language);
        }
        if (scriptEngine == null) {
            throw new FlowableException("Can't find scripting engine for '" + language + "'");
        }
        return scriptEngine;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public void addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
    }

    public void setCacheScriptingEngines(boolean cacheScriptingEngines) {
        this.cacheScriptingEngines = cacheScriptingEngines;
    }

    public boolean isCacheScriptingEngines() {
        return this.cacheScriptingEngines;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    protected class JavaScriptingFlowableScriptEvaluationRequest
    implements FlowableScriptEvaluationRequest {
        protected String language;
        protected String script;
        protected Resolver resolver;
        protected VariableContainer scopeContainer;
        protected VariableContainer inputVariableContainer;
        protected boolean storeScriptVariables;

        protected JavaScriptingFlowableScriptEvaluationRequest() {
        }

        @Override
        public FlowableScriptEvaluationRequest language(String language) {
            if (StringUtils.isEmpty((CharSequence)language)) {
                throw new FlowableIllegalArgumentException("language is empty");
            }
            this.language = language;
            return this;
        }

        @Override
        public FlowableScriptEvaluationRequest script(String script) {
            if (StringUtils.isEmpty((CharSequence)script)) {
                throw new FlowableIllegalArgumentException("script is empty");
            }
            this.script = script;
            return this;
        }

        @Override
        public FlowableScriptEvaluationRequest resolver(Resolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public FlowableScriptEvaluationRequest scopeContainer(VariableContainer scopeContainer) {
            this.scopeContainer = scopeContainer;
            return this;
        }

        @Override
        public FlowableScriptEvaluationRequest inputVariableContainer(VariableContainer inputVariableContainer) {
            this.inputVariableContainer = inputVariableContainer;
            return this;
        }

        @Override
        public FlowableScriptEvaluationRequest storeScriptVariables() {
            this.storeScriptVariables = true;
            return this;
        }

        @Override
        public ScriptEvaluation evaluate() throws FlowableScriptException {
            if (StringUtils.isEmpty((CharSequence)this.language)) {
                throw new FlowableIllegalArgumentException("language is required");
            }
            if (StringUtils.isEmpty((CharSequence)this.script)) {
                throw new FlowableIllegalArgumentException("script is required");
            }
            ScriptEngine scriptEngine = JSR223FlowableScriptEngine.this.getEngineByName(this.language);
            Bindings bindings = this.createBindings();
            try {
                Object result = scriptEngine.eval(this.script, bindings);
                return new ScriptEvaluationImpl(this.resolver, result);
            }
            catch (ScriptException e) {
                throw new FlowableScriptException(e.getMessage(), e);
            }
        }

        protected Bindings createBindings() {
            return new ScriptBindings(Collections.singletonList(this.resolver), this.scopeContainer, this.inputVariableContainer, this.storeScriptVariables);
        }
    }
}

