/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizationCodeAuthorizationResponseBuilder
extends BaseOAuth20AuthorizationResponseBuilder<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeAuthorizationResponseBuilder.class);

    public OAuth20AuthorizationCodeAuthorizationResponseBuilder(OAuth20ConfigurationContext context, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(context, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_AUTHORIZATION_RESPONSE", actionResolverName="OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_AUTHORIZATION_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        Authentication authentication = tokenRequestContext.getAuthentication();
        OAuth20CodeFactory factory = (OAuth20CodeFactory)this.configurationContext.getTicketFactory().get(OAuth20Code.class);
        OAuth20Code code = factory.create(tokenRequestContext.getService(), authentication, tokenRequestContext.getTicketGrantingTicket(), (Collection)tokenRequestContext.getScopes(), tokenRequestContext.getCodeChallenge(), tokenRequestContext.getCodeChallengeMethod(), tokenRequestContext.getClientId(), tokenRequestContext.getClaims(), tokenRequestContext.getResponseType(), tokenRequestContext.getGrantType());
        LOGGER.debug("Generated OAuth code: [{}]", (Object)code);
        Ticket addedCode = this.configurationContext.getTicketRegistry().addTicket((Ticket)code);
        Objects.requireNonNull(addedCode, () -> "Could not add OAuth code %s to the registry.".formatted(code.getId()));
        Ticket ticketGrantingTicket = tokenRequestContext.getTicketGrantingTicket();
        Optional.ofNullable(ticketGrantingTicket).ifPresent(tgt -> FunctionUtils.doAndHandle(ticket -> this.configurationContext.getTicketRegistry().updateTicket(ticket), throwable -> {
            LOGGER.error("Unable to update ticket-granting-ticket [{}]", (Object)ticketGrantingTicket, throwable);
            return null;
        }).accept(tgt));
        return this.buildCallbackViewViaRedirectUri(tokenRequestContext, addedCode);
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return Strings.CI.equals(context.getResponseType(), OAuth20ResponseTypes.CODE.getType());
    }

    protected ModelAndView buildCallbackViewViaRedirectUri(AccessTokenRequestContext holder, Ticket code) throws Exception {
        Map attributes = holder.getAuthentication().getAttributes();
        LOGGER.debug("Authorize request successful for client [{}] with redirect uri [{}]", (Object)holder.getClientId(), (Object)holder.getRedirectUri());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("code", code.getId());
        CollectionUtils.firstElement(attributes.get("state")).ifPresent(state -> params.put("state", state.toString()));
        CollectionUtils.firstElement(attributes.get("nonce")).ifPresent(nonce -> params.put("nonce", nonce.toString()));
        LOGGER.debug("Redirecting to URL [{}] with params [{}] for clientId [{}]", new Object[]{holder.getRedirectUri(), params.keySet(), holder.getClientId()});
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.configurationContext.getServicesManager(), holder.getClientId());
        return this.build(registeredService, holder.getResponseMode(), holder.getRedirectUri(), params);
    }
}

