/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.context.extensions.types;

import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import java.time.Duration;
import lombok.Generated;
import org.apache.wicket.util.lang.Bytes;

public class TypeParser {
    public static Bytes parse(Long size, SessionUnit sessionUnit) {
        return switch (sessionUnit) {
            default -> throw new IncompatibleClassChangeError();
            case SessionUnit.BYTES -> Bytes.bytes((long)size);
            case SessionUnit.KILOBYTES -> Bytes.kilobytes((long)size);
            case SessionUnit.MEGABYTES -> Bytes.megabytes((long)size);
            case SessionUnit.TERABYTES -> Bytes.terabytes((long)size);
        };
    }

    public static Duration parse(Long time, DurationUnit durationUnit) {
        return switch (durationUnit) {
            default -> throw new IncompatibleClassChangeError();
            case DurationUnit.DAYS -> Duration.ofDays(time);
            case DurationUnit.HOURS -> Duration.ofHours(time);
            case DurationUnit.MILLISECONDS -> Duration.ofMillis(time);
            case DurationUnit.MINUTES -> Duration.ofMinutes(time);
            case DurationUnit.SECONDS -> Duration.ofSeconds(time);
        };
    }

    @Generated
    private TypeParser() {
    }
}

