/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005q3AAE\n\u00011!)\u0011\u0006\u0001C\u0001U!)A\u0006\u0001C\u0001[!)a\b\u0001C\u0001[!)\u0001\t\u0001C\u0001[!)!\t\u0001C\u0001[!)A\t\u0001C\u0001[!)a\t\u0001C\u0001[!)\u0001\n\u0001C\u0001[!)!\n\u0001C\u0001[!)A\n\u0001C\u0001[!)a\n\u0001C\u0001[!)\u0001\u000b\u0001C\u0001[!)!\u000b\u0001C\u0001[!)A\u000b\u0001C\u0001[!)a\u000b\u0001C\u0001[!)\u0001\f\u0001C\u0001[!)!\f\u0001C\u0001[\t\u0011\u0012\tZ7j]J\u000b7m[!xCJ,G+Z:u\u0015\t!R#A\u0003bI6LgNC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\r GA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0011\u000e\u0003MI!AI\n\u0003\u001bI\u000b7m[!xCJ,G+Z:u!\t!s%D\u0001&\u0015\t1S#A\u0003vi&d7/\u0003\u0002)K\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001,!\t\u0001\u0003!A\u001duKN$x)\u001a;SC\u000e\\\u0017\t\u001c;fe:\fG/\u001a3Ce>\\WM\u001d'jgR\fe\u000eZ!tg&<gNU3qY&\u001c\u0017m\u001d+p\u0005J|7.\u001a:t)\u0005q\u0003C\u0001\u000e0\u0013\t\u00014D\u0001\u0003V]&$\bF\u0001\u00023!\t\u0019D(D\u00015\u0015\t)d'A\u0002ba&T!a\u000e\u001d\u0002\u000f),\b/\u001b;fe*\u0011\u0011HO\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002w\u0005\u0019qN]4\n\u0005u\"$\u0001\u0002+fgR\f1\u0004^3ti\u0006\u001b8/[4o[\u0016tGoV5uQJ\u000b7m[!xCJ,\u0007FA\u00023\u0003=\"Xm\u001d;BgNLwM\\7f]R<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sK^KG\u000f\u001b*b]\u0012|Wn\u0015;beRLe\u000eZ3yQ\t!!'A\u0017uKN$\u0018i]:jO:lWM\u001c;XSRD'+Y2l\u0003^\f'/Z,ji\",f.\u001a<f]J+\u0007\u000f\\5dCND#!\u0002\u001a\u0002UQ,7\u000f^!tg&<g.\\3oi^KG\u000f\u001b*bG.\fu/\u0019:f/&$\b.\u00168fm\u0016t'+Y2lg\"\u0012aAM\u0001%i\u0016\u001cH/Q:tS\u001etW.\u001a8u/&$\bN\r*fa2L7-Y:SC\u000e\\\u0017i^1sK\"\u0012qAM\u0001\u0017i\u0016\u001cHOU1dW\u0006;\u0018M]3FqB\fgn]5p]\"\u0012\u0001BM\u00014i\u0016\u001cH/Q:tS\u001etW.\u001a8u/&$\bN\r*fa2L7-Y:SC\u000e\\\u0017i^1sK^KG\u000f\u001b\u001cQCJ$\u0018\u000e^5p]ND#!\u0003\u001a\u0002}Q,7\u000f^!tg&<g.\\3oi^KG\u000f\u001b\u001aSKBd\u0017nY1t%\u0006\u001c7.Q<be\u0016<\u0016\u000e\u001e57!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c34\u0005J|7.\u001a:tQ\tQ!'A\u0012uKN$H*\u0019:hK:+XNY3s!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:lWM\u001c;)\u0005-\u0011\u0014!\u0007;fgRluN]3SKBd\u0017nY1t)\"\fgNU1dWND#\u0001\u0004\u001a\u00023Q,7\u000f\u001e'fgN\u0014V\r\u001d7jG\u0006\u001cH\u000b[1o%\u0006\u001c7n\u001d\u0015\u0003\u001bI\na\u0002^3tiNKgn\u001a7f%\u0006\u001c7\u000e\u000b\u0002\u000fe\u0005AC/Z:u'.L\u0007O\u0011:pW\u0016\u0014x+\u001b;i%\u0016\u0004H.[2b\u00032\u0014X-\u00193z\u0003N\u001c\u0018n\u001a8fI\"\u0012qBM\u0001\u0016i\u0016\u001cHOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\t\u0001\"'\u0001\u0019uKN$\u0018i]:jO:\u0014V\r\u001d7jG\u0006\u001cHk\u001c\"s_.,'o],ji\"LeN^1mS\u0012\u0004\u0016M]1nKR,'o\u001d\u0015\u0003#I\u0002")
public class AdminRackAwareTest
implements RackAwareTest,
Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Collection<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void testGetRackAlternatedBrokerListAndAssignReplicasToBrokers() {
        Map rackMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        List newList = AdminUtils.getRackAlternatedBrokerList((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)rackMap.map((Function1 & Serializable)e -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp()), e._2()))).asJava());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 5, 4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(newList).asScala().toList());
        List anotherList = AdminUtils.getRackAlternatedBrokerList((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)rackMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$minus((Object)BoxesRunTime.boxToInteger((int)5)).map((Function1 & Serializable)e -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp()), e._2()))).asJava());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(anotherList).asScala().toList());
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)rackMap, this.toBrokerMetadata$default$2()), (int)7, (int)3, (int)0, (int)0));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 4, 2})))}))), (Object)assignment);
    }

    @Test
    public void testAssignmentWithRackAware() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 3;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)2, (int)0));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWithRackAwareWithRandomStartIndex() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 3;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWithRackAwareWithUnevenReplicas() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 13;
        int replicationFactor = 3;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)0, (int)0));
        int x$3 = brokerRackMapping.size();
        boolean x$8 = this.checkReplicaDistribution$default$6();
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, x$3, numPartitions, replicationFactor, x$8, false, false);
    }

    @Test
    public void testAssignmentWithRackAwareWithUnevenRacks() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 3;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        int x$3 = brokerRackMapping.size();
        boolean x$7 = this.checkReplicaDistribution$default$6();
        boolean x$8 = this.checkReplicaDistribution$default$7();
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, x$3, numPartitions, replicationFactor, x$7, x$8, false);
    }

    @Test
    public void testAssignmentWith2ReplicasRackAware() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 2;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testRackAwareExpansion() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 2;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)12));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWith2ReplicasRackAwareWith6Partitions() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 2;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWith2ReplicasRackAwareWith6PartitionsAnd3Brokers() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3")}));
        int numPartitions = 3;
        int replicationFactor = 2;
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testLargeNumberPartitionsAssignment() {
        int numPartitions = 96;
        int replicationFactor = 3;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)"rack3")}));
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testMoreReplicasThanRacks() {
        int numPartitions = 6;
        int replicationFactor = 5;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack2")}));
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(assignment.size(), (Function0)(JFunction0.mcI.sp & Serializable)() -> replicationFactor), (Object)assignment.values().toIndexedSeq().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertEquals((int)3, (int)((IterableOnceOps)distribution.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size()));
    }

    @Test
    public void testLessReplicasThanRacks() {
        int numPartitions = 6;
        int replicationFactor = 2;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack2")}));
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(assignment.size(), (Function0)(JFunction0.mcI.sp & Serializable)() -> replicationFactor), (Object)assignment.values().toIndexedSeq().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertEquals((int)2, (int)((IterableOnceOps)distribution.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size()));
    }

    @Test
    public void testSingleRack() {
        int numPartitions = 6;
        int replicationFactor = 3;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(assignment.size(), (Function0)(JFunction0.mcI.sp & Serializable)() -> replicationFactor), (Object)assignment.values().toIndexedSeq().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertEquals((int)1, (int)((IterableOnceOps)distribution.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size()));
        brokerRackMapping.keys().foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)distribution.brokerLeaderCount().apply((Object)BoxesRunTime.boxToInteger((int)broker)))));
    }

    @Test
    public void testSkipBrokerWithReplicaAlreadyAssigned() {
        Map rackInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"a")}));
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4);
        int numPartitions = 6;
        int replicationFactor = 4;
        Collection<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2());
        Assertions.assertEquals((Object)brokerList, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(brokerMetadatas).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id)));
        Map assignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(brokerMetadatas, (int)numPartitions, (int)replicationFactor, (int)2, (int)-1));
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, 5, 6, 4, false, false, false);
    }

    @Test
    public void testReplicaAssignment() {
        List brokerMetadatas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$5 -> AdminRackAwareTest.$anonfun$testReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)x$5)))).asJava();
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)0));
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)6));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)3, (int)0, (int)-1));
        Assertions.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testAssignReplicasToBrokersWithInvalidParameters() {
        Map rackMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), null)}));
        Collection<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackMap, this.toBrokerMetadata$default$2());
        Assertions.assertThrows(InvalidPartitionsException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)0, (int)0, (int)-1, (int)-1));
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)0, (int)-1, (int)-1));
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)(brokerMetadatas.size() + 1), (int)-1, (int)-1));
        Assertions.assertThrows(AdminOperationException.class, () -> AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)10, (int)brokerMetadatas.size(), (int)-1, (int)-1));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testReplicaAssignment$1(int x$5) {
        return new BrokerMetadata(x$5, Optional.empty());
    }
}

