/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HexPasswordEncoderOutputFormatter
extends PasswordEncoderOutputFormatter {
    @NotNull
    private static final HexPasswordEncoderOutputFormatter LOWERCASE_INSTANCE = new HexPasswordEncoderOutputFormatter(true);
    @NotNull
    private static final HexPasswordEncoderOutputFormatter UPPERCASE_INSTANCE = new HexPasswordEncoderOutputFormatter(false);
    private final boolean useLowercaseLetters;

    private HexPasswordEncoderOutputFormatter(boolean useLowercaseLetters) {
        this.useLowercaseLetters = useLowercaseLetters;
    }

    @NotNull
    public static HexPasswordEncoderOutputFormatter getLowercaseInstance() {
        return LOWERCASE_INSTANCE;
    }

    @NotNull
    public static HexPasswordEncoderOutputFormatter getUppercaseInstance() {
        return UPPERCASE_INSTANCE;
    }

    public boolean useLowercaseLetters() {
        return this.useLowercaseLetters;
    }

    @Override
    @NotNull
    public byte[] format(@NotNull byte[] unformattedData) throws LDAPException {
        String hexString = StaticUtils.toHex(unformattedData);
        if (!this.useLowercaseLetters) {
            hexString = hexString.toUpperCase();
        }
        return StaticUtils.getBytes(hexString);
    }

    @Override
    @NotNull
    public byte[] unFormat(@NotNull byte[] formattedData) throws LDAPException {
        try {
            return StaticUtils.fromHex(StaticUtils.toUTF8String(formattedData));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_HEX_PW_FORMATTER_CANNOT_DECODE.get(), e);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("HexPasswordEncoderOutputFormatter(useLowercaseLetters=");
        buffer.append(this.useLowercaseLetters);
        buffer.append(')');
    }
}

