/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.AuthModuleRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AuthModuleWizardBuilder;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AuthModuleDirectoryPanel
extends DirectoryPanel<AuthModuleTO, AuthModuleTO, AuthModuleProvider, AuthModuleRestClient> {
    private static final long serialVersionUID = 1005345990563741296L;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final BaseModal<Serializable> historyModal;

    public AuthModuleDirectoryPanel(String id, AuthModuleRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.disableCheckBoxes();
        this.addNewItemPanelBuilder((ModalPanelBuilder)new AuthModuleWizardBuilder(new AuthModuleTO(), restClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"AUTH_MODULE_CREATE");
        this.modal.size(Modal.Size.Extra_large);
        this.initResultTable();
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    protected AuthModuleProvider dataProvider() {
        return new AuthModuleProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "authmodule.paginator.rows";
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected List<IColumn<AuthModuleTO, String>> getColumns() {
        ArrayList<IColumn<AuthModuleTO, String>> columns = new ArrayList<IColumn<AuthModuleTO, String>>();
        columns.add((IColumn<AuthModuleTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<AuthModuleTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((IColumn<AuthModuleTO, String>)new PropertyColumn<AuthModuleTO, String>((IModel)new ResourceModel("type"), "conf"){
            private static final long serialVersionUID = -1822504503325964706L;

            public void populateItem(Item<ICellPopulator<AuthModuleTO>> item, String componentId, IModel<AuthModuleTO> rowModel) {
                item.add(new Component[]{new Label(componentId, (Serializable)((Object)(((AuthModuleTO)rowModel.getObject()).getConf() == null ? "" : StringUtils.substringBefore((String)((AuthModuleTO)rowModel.getObject()).getConf().getClass().getSimpleName(), (String)"AuthModuleConf"))))});
            }
        });
        columns.add((IColumn<AuthModuleTO, String>)new PropertyColumn((IModel)new ResourceModel("state"), (Object)"state", "state"));
        columns.add((IColumn<AuthModuleTO, String>)new PropertyColumn((IModel)new ResourceModel("order"), (Object)"order", "order"));
        return columns;
    }

    public ActionsPanel<AuthModuleTO> getActions(final IModel<AuthModuleTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<AuthModuleTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AuthModuleDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AuthModuleTO ignore) {
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((AuthModuleRestClient)this.this$0.restClient).read(((AuthModuleTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "AUTH_MODULE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthModuleTO>(this){
            private static final long serialVersionUID = -5432034353017728756L;
            final /* synthetic */ AuthModuleDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AuthModuleTO ignore) {
                model.setObject((Object)((AuthModuleRestClient)this.this$0.restClient).read(((AuthModuleTO)model.getObject()).getKey()));
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<AuthModuleTO>(this, OpEvent.CategoryType.LOGIC, "AuthModuleLogic", (AuthModuleTO)model.getObject(), "AUTH_MODULE_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033822L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            AuthModuleTO updated = (AuthModuleTO)DirectoryPanel.MAPPER.readValue(json, AuthModuleTO.class);
                            ((AuthModuleRestClient)this.this$1.this$0.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring AuthModule {}", (Object)((AuthModuleTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.this$1.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)this.this$0.getString("auditHistory.title", (IModel)new Model((Serializable)((AuthModuleTO)model.getObject()))))));
                this.this$0.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "AUTH_MODULE_READ", "AUDIT_LIST"));
        panel.add((ActionLink)new ActionLink<AuthModuleTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AuthModuleDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AuthModuleTO ignore) {
                try {
                    ((AuthModuleRestClient)this.this$0.restClient).delete(((AuthModuleTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((AuthModuleTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "AUTH_MODULE_DELETE", true);
        return panel;
    }

    protected final class AuthModuleProvider
    extends DirectoryDataProvider<AuthModuleTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AuthModuleTO> comparator;

        private AuthModuleProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<AuthModuleTO> iterator(long first, long count) {
            List<AuthModuleTO> authModules = ((AuthModuleRestClient)AuthModuleDirectoryPanel.this.restClient).list();
            authModules.sort((Comparator<AuthModuleTO>)this.comparator);
            return authModules.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((AuthModuleRestClient)AuthModuleDirectoryPanel.this.restClient).list().size();
        }

        public IModel<AuthModuleTO> model(AuthModuleTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

