/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.model.BatchCheckRequest;
import org.apache.syncope.ext.openfga.client.model.BatchCheckResponse;
import org.apache.syncope.ext.openfga.client.model.CheckRequest;
import org.apache.syncope.ext.openfga.client.model.CheckResponse;
import org.apache.syncope.ext.openfga.client.model.ExpandRequest;
import org.apache.syncope.ext.openfga.client.model.ExpandResponse;
import org.apache.syncope.ext.openfga.client.model.ListObjectsRequest;
import org.apache.syncope.ext.openfga.client.model.ListObjectsResponse;
import org.apache.syncope.ext.openfga.client.model.ListUsersRequest;
import org.apache.syncope.ext.openfga.client.model.ListUsersResponse;
import org.apache.syncope.ext.openfga.client.model.StreamResultOfStreamedListObjectsResponse;

public class RelationshipQueriesApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<InputStream>> memberVarAsyncResponseInterceptor;

    public RelationshipQueriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RelationshipQueriesApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = null;
        try (InputStream responseBody = ApiClient.getResponseBody(response);){
            body = responseBody == null ? null : new String(responseBody.readAllBytes());
        }
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response, InputStream responseBody) throws ApiException {
        if (responseBody == null) {
            throw new ApiException(new IOException("Response body is empty"));
        }
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(responseBody, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public BatchCheckResponse batchCheck(@Nonnull String storeId, @Nonnull BatchCheckRequest body) throws ApiException {
        return this.batchCheck(storeId, body, null);
    }

    public BatchCheckResponse batchCheck(@Nonnull String storeId, @Nonnull BatchCheckRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<BatchCheckResponse> localVarResponse = this.batchCheckWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<BatchCheckResponse> batchCheckWithHttpInfo(@Nonnull String storeId, @Nonnull BatchCheckRequest body) throws ApiException {
        return this.batchCheckWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<BatchCheckResponse> batchCheckWithHttpInfo(@Nonnull String storeId, @Nonnull BatchCheckRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.batchCheckRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("batchCheck", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                BatchCheckResponse responseValue = responseBody.isBlank() ? null : (BatchCheckResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<BatchCheckResponse>(this){});
                ApiResponse<BatchCheckResponse> apiResponse = new ApiResponse<BatchCheckResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder batchCheckRequestBuilder(@Nonnull String storeId, @Nonnull BatchCheckRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling batchCheck");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchCheck");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/batch-check".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CheckResponse check(@Nonnull String storeId, @Nonnull CheckRequest body) throws ApiException {
        return this.check(storeId, body, null);
    }

    public CheckResponse check(@Nonnull String storeId, @Nonnull CheckRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<CheckResponse> localVarResponse = this.checkWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<CheckResponse> checkWithHttpInfo(@Nonnull String storeId, @Nonnull CheckRequest body) throws ApiException {
        return this.checkWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<CheckResponse> checkWithHttpInfo(@Nonnull String storeId, @Nonnull CheckRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.checkRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("check", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                CheckResponse responseValue = responseBody.isBlank() ? null : (CheckResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CheckResponse>(this){});
                ApiResponse<CheckResponse> apiResponse = new ApiResponse<CheckResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder checkRequestBuilder(@Nonnull String storeId, @Nonnull CheckRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling check");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling check");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/check".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ExpandResponse expand(@Nonnull String storeId, @Nonnull ExpandRequest body) throws ApiException {
        return this.expand(storeId, body, null);
    }

    public ExpandResponse expand(@Nonnull String storeId, @Nonnull ExpandRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<ExpandResponse> localVarResponse = this.expandWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ExpandResponse> expandWithHttpInfo(@Nonnull String storeId, @Nonnull ExpandRequest body) throws ApiException {
        return this.expandWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ExpandResponse> expandWithHttpInfo(@Nonnull String storeId, @Nonnull ExpandRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.expandRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("expand", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ExpandResponse responseValue = responseBody.isBlank() ? null : (ExpandResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ExpandResponse>(this){});
                ApiResponse<ExpandResponse> apiResponse = new ApiResponse<ExpandResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder expandRequestBuilder(@Nonnull String storeId, @Nonnull ExpandRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling expand");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling expand");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/expand".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ListObjectsResponse listObjects(@Nonnull String storeId, @Nonnull ListObjectsRequest body) throws ApiException {
        return this.listObjects(storeId, body, null);
    }

    public ListObjectsResponse listObjects(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<ListObjectsResponse> localVarResponse = this.listObjectsWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ListObjectsResponse> listObjectsWithHttpInfo(@Nonnull String storeId, @Nonnull ListObjectsRequest body) throws ApiException {
        return this.listObjectsWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ListObjectsResponse> listObjectsWithHttpInfo(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listObjectsRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("listObjects", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ListObjectsResponse responseValue = responseBody.isBlank() ? null : (ListObjectsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ListObjectsResponse>(this){});
                ApiResponse<ListObjectsResponse> apiResponse = new ApiResponse<ListObjectsResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listObjectsRequestBuilder(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling listObjects");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listObjects");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/list-objects".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ListUsersResponse listUsers(@Nonnull String storeId, @Nonnull ListUsersRequest body) throws ApiException {
        return this.listUsers(storeId, body, null);
    }

    public ListUsersResponse listUsers(@Nonnull String storeId, @Nonnull ListUsersRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<ListUsersResponse> localVarResponse = this.listUsersWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ListUsersResponse> listUsersWithHttpInfo(@Nonnull String storeId, @Nonnull ListUsersRequest body) throws ApiException {
        return this.listUsersWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ListUsersResponse> listUsersWithHttpInfo(@Nonnull String storeId, @Nonnull ListUsersRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listUsersRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("listUsers", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ListUsersResponse responseValue = responseBody.isBlank() ? null : (ListUsersResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ListUsersResponse>(this){});
                ApiResponse<ListUsersResponse> apiResponse = new ApiResponse<ListUsersResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listUsersRequestBuilder(@Nonnull String storeId, @Nonnull ListUsersRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling listUsers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listUsers");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/list-users".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StreamResultOfStreamedListObjectsResponse streamedListObjects(@Nonnull String storeId, @Nonnull ListObjectsRequest body) throws ApiException {
        return this.streamedListObjects(storeId, body, null);
    }

    public StreamResultOfStreamedListObjectsResponse streamedListObjects(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<StreamResultOfStreamedListObjectsResponse> localVarResponse = this.streamedListObjectsWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<StreamResultOfStreamedListObjectsResponse> streamedListObjectsWithHttpInfo(@Nonnull String storeId, @Nonnull ListObjectsRequest body) throws ApiException {
        return this.streamedListObjectsWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<StreamResultOfStreamedListObjectsResponse> streamedListObjectsWithHttpInfo(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.streamedListObjectsRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("streamedListObjects", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                StreamResultOfStreamedListObjectsResponse responseValue = responseBody.isBlank() ? null : (StreamResultOfStreamedListObjectsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<StreamResultOfStreamedListObjectsResponse>(this){});
                ApiResponse<StreamResultOfStreamedListObjectsResponse> apiResponse = new ApiResponse<StreamResultOfStreamedListObjectsResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder streamedListObjectsRequestBuilder(@Nonnull String storeId, @Nonnull ListObjectsRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling streamedListObjects");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling streamedListObjects");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/streamed-list-objects".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

