/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.List;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.transforms.BlockingPrincipalNameTransformer;
import org.apereo.cas.util.transforms.ChainingPrincipalNameTransformer;
import org.apereo.cas.util.transforms.ConvertCasePrincipalNameTransformer;
import org.apereo.cas.util.transforms.GroovyPrincipalNameTransformer;
import org.apereo.cas.util.transforms.PrefixSuffixPrincipalNameTransformer;
import org.apereo.cas.util.transforms.RegexPrincipalNameTransformer;

public final class PrincipalNameTransformerUtils {
    public static PrincipalNameTransformer newPrincipalNameTransformer(PrincipalTransformationProperties properties) {
        GroovyPrincipalNameTransformer transformer;
        ChainingPrincipalNameTransformer chain = new ChainingPrincipalNameTransformer();
        if (properties.getGroovy().getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage() && ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory().isPresent()) {
            transformer = new GroovyPrincipalNameTransformer(properties.getGroovy().getLocation());
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getPattern())) {
            transformer = new RegexPrincipalNameTransformer(SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getPattern()));
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getPrefix()) || StringUtils.isNotBlank((CharSequence)properties.getSuffix())) {
            transformer = new PrefixSuffixPrincipalNameTransformer();
            transformer.setPrefix(SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getPrefix()));
            transformer.setSuffix(SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getSuffix()));
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        if (properties.getCaseConversion() == PrincipalTransformationProperties.CaseConversion.UPPERCASE) {
            transformer = new ConvertCasePrincipalNameTransformer();
            transformer.setToUpperCase(true);
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        if (properties.getCaseConversion() == PrincipalTransformationProperties.CaseConversion.LOWERCASE) {
            transformer = new ConvertCasePrincipalNameTransformer();
            transformer.setToUpperCase(false);
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getBlockingPattern())) {
            transformer = new BlockingPrincipalNameTransformer(SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getBlockingPattern()));
            chain.addTransformer((PrincipalNameTransformer)transformer);
        }
        List<PrincipalNameTransformer> transformers = ServiceLoader.load(PrincipalNameTransformer.class).stream().map(ServiceLoader.Provider::get).toList();
        chain.addTransformers(transformers);
        return chain;
    }

    @Generated
    private PrincipalNameTransformerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

