/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.List;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;

@FunctionalInterface
public interface TenantPersonAttributeDaoBuilder {
    default public List<? extends PersonAttributeDao> build(TenantDefinition tenantDefinition) {
        ConfigurationPropertiesBindingContext bindingContext = tenantDefinition.bindProperties();
        if (bindingContext.isBound()) {
            List<? extends PersonAttributeDao> repositories = this.buildInternal(tenantDefinition, (ConfigurationPropertiesBindingContext<CasConfigurationProperties>)bindingContext);
            repositories.forEach(PersonAttributeDao::markDisposable);
            return repositories;
        }
        return List.of();
    }

    public List<? extends PersonAttributeDao> buildInternal(TenantDefinition var1, ConfigurationPropertiesBindingContext<CasConfigurationProperties> var2);

    public static TenantPersonAttributeDaoBuilder noOp() {
        return (tenantDefinition, bindingContext) -> List.of();
    }
}

