/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    @Autowired
    protected ImplementationDAO implementationDAO;

    protected void before(ExternalResource resource, Connector connector, PushTaskTO pushTaskTO, String executor) {
        LOG.debug("Executing push on {}", (Object)resource);
        this.taskType = TaskType.PUSH;
        this.task = (SchedTask)this.entityFactory.newEntity(PushTask.class);
        ((PushTask)this.task).setResource(resource);
        ((PushTask)this.task).setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
        ((PushTask)this.task).setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
        ((PushTask)this.task).setPerformCreate(pushTaskTO.isPerformCreate());
        ((PushTask)this.task).setPerformUpdate(pushTaskTO.isPerformUpdate());
        ((PushTask)this.task).setPerformDelete(pushTaskTO.isPerformDelete());
        ((PushTask)this.task).setSyncStatus(pushTaskTO.isSyncStatus());
        this.profile = new ProvisioningProfile(connector, this.taskType, (ProvisioningTask)((PushTask)this.task), ConflictResolutionAction.FIRSTMATCH, this.getPushActions(pushTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).findById(arg_0)).flatMap(Optional::stream).toList()), executor, false);
        for (PushActions action : this.profile.getActions()) {
            action.beforeAll(this.profile);
        }
    }

    @Transactional(readOnly=true)
    public List<ProvisioningReport> push(ExternalResource resource, Provision provision, Connector connector, Any any, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        try {
            this.before(resource, connector, pushTaskTO, executor);
            this.dispatcher = this.buildDispatcher();
            this.dispatcher.addHandlerSupplier(provision.getAnyType(), () -> {
                UserPushResultHandler handler = switch (any.getType().getKind()) {
                    case AnyTypeKind.USER -> this.buildUserHandler();
                    case AnyTypeKind.GROUP -> this.buildGroupHandler();
                    default -> this.buildAnyObjectHandler();
                };
                handler.setProfile(this.profile);
                return handler;
            });
            this.doHandle(List.of(any), this.dispatcher, resource);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            JobExecutionException jobExecutionException;
            throw e instanceof JobExecutionException ? (jobExecutionException = (JobExecutionException)((Object)e)) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public ProvisioningReport push(ExternalResource resource, Provision provision, Connector connector, LinkedAccount account, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        try {
            this.before(resource, connector, pushTaskTO, executor);
            UserPushResultHandler handler = this.buildUserHandler();
            handler.setProfile(this.profile);
            handler.handle(account, provision);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return (ProvisioningReport)this.profile.getResults().getFirst();
        }
        catch (Exception e) {
            JobExecutionException jobExecutionException;
            throw e instanceof JobExecutionException ? (jobExecutionException = (JobExecutionException)((Object)e)) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }
}

