/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;

@InterfaceStability.Evolving
public class StateQueryRequest<R> {
    private final String storeName;
    private final PositionBound position;
    private final Optional<Set<Integer>> partitions;
    private final Query<R> query;
    private final boolean executionInfoEnabled;
    private final boolean requireActive;

    private StateQueryRequest(String storeName, PositionBound position, Optional<Set<Integer>> partitions, Query<R> query, boolean executionInfoEnabled, boolean requireActive) {
        this.storeName = storeName;
        this.position = position;
        this.partitions = partitions;
        this.query = query;
        this.executionInfoEnabled = executionInfoEnabled;
        this.requireActive = requireActive;
    }

    public static InStore inStore(String name) {
        return new InStore(name);
    }

    public StateQueryRequest<R> withPositionBound(PositionBound positionBound) {
        return new StateQueryRequest<R>(this.storeName, positionBound, this.partitions, this.query, this.executionInfoEnabled, this.requireActive);
    }

    public StateQueryRequest<R> withAllPartitions() {
        return new StateQueryRequest<R>(this.storeName, this.position, Optional.empty(), this.query, this.executionInfoEnabled, this.requireActive);
    }

    public StateQueryRequest<R> withPartitions(Set<Integer> partitions) {
        return new StateQueryRequest<R>(this.storeName, this.position, Optional.of(Collections.unmodifiableSet(new HashSet<Integer>(partitions))), this.query, this.executionInfoEnabled, this.requireActive);
    }

    public StateQueryRequest<R> enableExecutionInfo() {
        return new StateQueryRequest<R>(this.storeName, this.position, this.partitions, this.query, true, this.requireActive);
    }

    public StateQueryRequest<R> requireActive() {
        return new StateQueryRequest<R>(this.storeName, this.position, this.partitions, this.query, this.executionInfoEnabled, true);
    }

    public String getStoreName() {
        return this.storeName;
    }

    public PositionBound getPositionBound() {
        return this.position;
    }

    public Query<R> getQuery() {
        return this.query;
    }

    public boolean isAllPartitions() {
        return !this.partitions.isPresent();
    }

    public Set<Integer> getPartitions() {
        if (!this.partitions.isPresent()) {
            throw new IllegalStateException("Cannot list partitions of an 'all partitions' request");
        }
        return this.partitions.get();
    }

    public boolean executionInfoEnabled() {
        return this.executionInfoEnabled;
    }

    public boolean isRequireActive() {
        return this.requireActive;
    }

    public static class InStore {
        private final String name;

        private InStore(String name) {
            this.name = name;
        }

        public <R> StateQueryRequest<R> withQuery(Query<R> query) {
            return new StateQueryRequest(this.name, PositionBound.unbounded(), Optional.empty(), query, false, false);
        }
    }
}

