/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.Ordered;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authorization.method.AuthorizationAdvisorProxyFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Configuration
class AuthorizationProxyWebConfiguration {
    AuthorizationProxyWebConfiguration() {
    }

    @Bean
    @Role(value=2)
    AuthorizationAdvisorProxyFactory.TargetVisitor webTargetVisitor() {
        return new WebTargetVisitor();
    }

    static class WebTargetVisitor
    implements AuthorizationAdvisorProxyFactory.TargetVisitor,
    Ordered {
        private static final int DEFAULT_ORDER = 100;

        WebTargetVisitor() {
        }

        public Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object target) {
            if (target instanceof ResponseEntity) {
                ResponseEntity entity = (ResponseEntity)target;
                return new ResponseEntity(proxyFactory.proxy(entity.getBody()), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
            }
            if (target instanceof HttpEntity) {
                HttpEntity entity = (HttpEntity)target;
                return new HttpEntity(proxyFactory.proxy(entity.getBody()), (MultiValueMap)entity.getHeaders());
            }
            if (target instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)target;
                View view = mav.getView();
                String viewName = mav.getViewName();
                Map model = (Map)proxyFactory.proxy((Object)mav.getModel());
                ModelAndView proxied = view != null ? new ModelAndView(view, model) : new ModelAndView(viewName, model);
                proxied.setStatus(mav.getStatus());
                return proxied;
            }
            return null;
        }

        public int getOrder() {
            return 100;
        }
    }
}

