/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.panels.ConnObjects;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.status.ResourceStatusModal;
import org.apache.syncope.client.console.tasks.LiveSyncTask;
import org.apache.syncope.client.console.tasks.PropagationTasks;
import org.apache.syncope.client.console.tasks.PullTasks;
import org.apache.syncope.client.console.tasks.PushTasks;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.client.console.wizards.resources.ResourceProvisionPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.IndicatingOnConfirmAjaxLink;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class TopologyTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -2025535531121434056L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final WebMarkupContainer container;
    protected final BaseModal<Serializable> propTaskModal;
    protected final BaseModal<Serializable> schedTaskModal;
    protected final BaseModal<Serializable> provisionModal;
    protected final BaseModal<Serializable> historyModal;

    public TopologyTogglePanel(String id, PageReference pageRef) {
        super(id, "topologyTogglePanel", pageRef);
        this.modal.size(Modal.Size.Large);
        this.setFooterVisibility(false);
        this.propTaskModal = new BaseModal("outer");
        this.propTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.propTaskModal});
        this.schedTaskModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.schedTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.schedTaskModal});
        this.provisionModal = new BaseModal("outer");
        this.provisionModal.size(Modal.Size.Large);
        this.provisionModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.provisionModal});
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupPlaceholderTag(true);
        this.addInnerObject(new Component[]{this.container});
        this.container.add(new Component[]{this.getEmptyFragment()});
    }

    public void toggleWithContent(AjaxRequestTarget target, TopologyNode node) {
        this.setHeader(target, node.getDisplayName());
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)t -> {
            this.modal.show(false);
            this.send((IEventSink)this.pageRef.getPage(), Broadcast.DEPTH, new UpdateEvent(node.getKey(), t));
        });
        switch (node.getKind()) {
            case SYNCOPE: {
                this.container.addOrReplace(new Component[]{this.getSyncopeFragment(this.pageRef)});
                break;
            }
            case CONNECTOR_SERVER: {
                this.container.addOrReplace(new Component[]{this.getLocationFragment(node, this.pageRef)});
                break;
            }
            case FS_PATH: {
                this.container.addOrReplace(new Component[]{this.getLocationFragment(node, this.pageRef)});
                break;
            }
            case CONNECTOR: {
                this.container.addOrReplace(new Component[]{this.getConnectorFragment(node, this.pageRef)});
                break;
            }
            case RESOURCE: {
                this.container.addOrReplace(new Component[]{this.getResourceFragment(node, this.pageRef)});
                break;
            }
            default: {
                this.container.addOrReplace(new Component[]{this.getEmptyFragment()});
            }
        }
        target.add(new Component[]{this.container});
        this.toggle(target, node, true);
    }

    protected String getTargetKey(Serializable modelObject) {
        if (modelObject instanceof ResourceProvision) {
            ResourceProvision resourceProvision = (ResourceProvision)((Object)modelObject);
            return resourceProvision.getKey();
        }
        if (modelObject instanceof TopologyNode) {
            TopologyNode topologyNode = (TopologyNode)modelObject;
            return topologyNode.getKey();
        }
        return super.getTargetKey(modelObject);
    }

    private Fragment getEmptyFragment() {
        return new Fragment("actions", "emptyFragment", (MarkupContainer)this);
    }

    private Fragment getSyncopeFragment(final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "syncopeActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> reload = new IndicatingOnConfirmAjaxLink<String>(this, "reload", "connectors.confirm.reload", true){
            private static final long serialVersionUID = -2075933173666007020L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id, msg, enabled);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    this.this$0.connectorRestClient.reload();
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While reloading all connectors", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        fragment.add(new Component[]{reload});
        MetaDataRoleAuthorizationStrategy.authorize((Component)reload, (Action)RENDER, (String)"CONNECTOR_RELOAD");
        return fragment;
    }

    private Fragment getLocationFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "locationActions", (MarkupContainer)this);
        IndicatingAjaxLink<String> create = new IndicatingAjaxLink<String>(this, "create"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO modelObject = new ConnInstanceTO();
                modelObject.setLocation(node.getKey());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                this.this$0.modal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.modal.setContent((ModalPanel)new ConnectorWizardBuilder(modelObject, this.this$0.connectorRestClient, pageRef).build("content", AjaxWizard.Mode.CREATE))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.new"), node.getKey()))));
                this.this$0.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        fragment.add(new Component[]{create});
        MetaDataRoleAuthorizationStrategy.authorize((Component)create, (Action)RENDER, (String)"CONNECTOR_CREATE");
        return fragment;
    }

    private Fragment getConnectorFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "connectorActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> delete = new IndicatingOnConfirmAjaxLink<String>(this, "delete", "confirmDelete", true){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id, msg, enabled);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    this.this$0.connectorRestClient.delete(node.getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", node.getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    this.this$0.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)delete, (Action)RENDER, (String)"CONNECTOR_DELETE");
        fragment.add(new Component[]{delete});
        IndicatingAjaxLink<String> create = new IndicatingAjaxLink<String>(this, "create"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = new ResourceTO();
                modelObject.setConnector(node.getKey());
                modelObject.setConnectorDisplayName(node.getDisplayName());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                this.this$0.modal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(modelObject, this.this$0.resourceRestClient, this.this$0.connectorRestClient, pageRef).build("content", AjaxWizard.Mode.CREATE))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.new"), node.getKey()))));
                this.this$0.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)create, (Action)RENDER, (String)"RESOURCE_CREATE");
        fragment.add(new Component[]{create});
        IndicatingAjaxLink<String> edit = new IndicatingAjaxLink<String>(this, "edit"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO connInstance = this.this$0.connectorRestClient.read(node.getKey());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)connInstance);
                this.this$0.modal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.modal.setContent((ModalPanel)new ConnectorWizardBuilder(connInstance, this.this$0.connectorRestClient, pageRef).build("content", SyncopeConsoleSession.get().owns("CONNECTOR_UPDATE", new String[]{connInstance.getAdminRealm()}) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.edit"), connInstance.getDisplayName()))));
                this.this$0.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"CONNECTOR_READ");
        fragment.add(new Component[]{edit});
        IndicatingAjaxLink<String> history = new IndicatingAjaxLink<String>(this, "history"){
            private static final long serialVersionUID = -1876519166660008562L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO modelObject = this.this$0.connectorRestClient.read(node.getKey());
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<ConnInstanceTO>(this, OpEvent.CategoryType.LOGIC, "ConnectorLogic", modelObject, "CONNECTOR_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3225348282675513648L;
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ConnInstanceTO updated = (ConnInstanceTO)MAPPER.readValue(json, ConnInstanceTO.class);
                            this.this$1.this$0.connectorRestClient.update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            this.this$1.this$0.toggle(target, false);
                        }
                        catch (Exception e) {
                            LOG.error("While restoring connector {}", (Object)node.getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.menu.history"), node.getDisplayName()))));
                this.this$0.historyModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)history, (Action)RENDER, (String)String.format("%s,%s", "CONNECTOR_READ", "AUDIT_LIST"));
        fragment.add(new Component[]{history});
        return fragment;
    }

    private Fragment getResourceFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "resourceActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> delete = new IndicatingOnConfirmAjaxLink<String>(this, "delete", "confirmDelete", true){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id, msg, enabled);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    this.this$0.resourceRestClient.delete(node.getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", node.getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    this.this$0.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)delete, (Action)RENDER, (String)"RESOURCE_DELETE");
        fragment.add(new Component[]{delete});
        IndicatingAjaxLink<String> edit = new IndicatingAjaxLink<String>(this, "edit"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = this.this$0.resourceRestClient.read(node.getKey());
                ConnInstanceTO connInstance = this.this$0.connectorRestClient.read(resource.getConnector());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                this.this$0.modal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(resource, this.this$0.resourceRestClient, this.this$0.connectorRestClient, pageRef).build("content", SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{connInstance.getAdminRealm()}) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.edit"), node.getKey()))));
                this.this$0.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"RESOURCE_READ");
        fragment.add(new Component[]{edit});
        IndicatingAjaxLink<String> status = new IndicatingAjaxLink<String>(this, "reconciliation"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = this.this$0.resourceRestClient.read(node.getKey());
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new ResourceStatusModal(pageRef, modelObject))});
                this.this$0.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.reconciliation"), node.getKey()))));
                this.this$0.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)status, (Action)RENDER, (String)"USER_UPDATE");
        fragment.add(new Component[]{status});
        IndicatingAjaxLink<String> provision = new IndicatingAjaxLink<String>(this, "provision"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = this.this$0.resourceRestClient.read(node.getKey());
                ConnInstanceTO connInstance = this.this$0.connectorRestClient.read(resource.getConnector());
                if (SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{connInstance.getAdminRealm()})) {
                    this.this$0.provisionModal.addSubmitButton();
                } else {
                    this.this$0.provisionModal.removeSubmitButton();
                }
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                this.this$0.provisionModal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.provisionModal.setContent((ModalPanel)new ResourceProvisionPanel(this.this$0.provisionModal, resource, connInstance.getAdminRealm(), pageRef))});
                this.this$0.provisionModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.edit"), node.getKey()))));
                this.this$0.provisionModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"RESOURCE_READ");
        fragment.add(new Component[]{provision});
        IndicatingAjaxLink<String> explore = new IndicatingAjaxLink<String>(this, "explore"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = this.this$0.resourceRestClient.read(node.getKey());
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new ConnObjects(resource, pageRef))});
                this.this$0.propTaskModal.header((IModel)new StringResourceModel("resource.explore.list", (IModel)Model.of((Serializable)node)));
                this.this$0.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)explore, (Action)RENDER, (String)"RESOURCE_LIST_CONNOBJECT");
        fragment.add(new Component[]{explore});
        IndicatingAjaxLink<String> propagation = new IndicatingAjaxLink<String>(this, "propagation"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new PropagationTasks(this.this$0.propTaskModal, node.getKey(), pageRef))});
                this.this$0.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.propagation.list"), node.getKey()))));
                this.this$0.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)propagation, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{propagation});
        IndicatingAjaxLink<String> pull = new IndicatingAjaxLink<String>(this, "pull"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new PullTasks(this.this$0.schedTaskModal, node.getKey(), pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.pull.list"), node.getKey()))));
                this.this$0.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)pull, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{pull});
        IndicatingAjaxLink<String> livesync = new IndicatingAjaxLink<String>(this, "livesync"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new LiveSyncTask(this.this$0.schedTaskModal, node.getKey(), pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.livesync"), node.getKey()))));
                this.this$0.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)livesync, (Action)RENDER, (String)"TASK_READ");
        fragment.add(new Component[]{livesync});
        IndicatingAjaxLink<String> push = new IndicatingAjaxLink<String>(this, "push"){
            private static final long serialVersionUID = 3776750333491622263L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new PushTasks(this.this$0.schedTaskModal, node.getKey(), pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.push.list"), node.getKey()))));
                this.this$0.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)push, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{push});
        IndicatingAjaxLink<String> history = new IndicatingAjaxLink<String>(this, "history"){
            private static final long serialVersionUID = -1876519166660008562L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = this.this$0.resourceRestClient.read(node.getKey());
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<ResourceTO>(this, OpEvent.CategoryType.LOGIC, "ResourceLogic", modelObject, "RESOURCE_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033811L;
                    final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ResourceTO updated = (ResourceTO)MAPPER.readValue(json, ResourceTO.class);
                            this.this$1.this$0.resourceRestClient.update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            this.this$1.this$0.toggle(target, false);
                        }
                        catch (Exception e) {
                            LOG.error("While restoring resource {}", (Object)node.getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.menu.history"), node.getDisplayName()))));
                this.this$0.historyModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)history, (Action)RENDER, (String)String.format("%s,%s", "RESOURCE_READ", "AUDIT_LIST"));
        fragment.add(new Component[]{history});
        IndicatingAjaxLink<String> clone = new IndicatingAjaxLink<String>(this, "clone"){
            private static final long serialVersionUID = -7978723352517770644L;
            final /* synthetic */ TopologyTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    ResourceTO resource = this.this$0.resourceRestClient.read(node.getKey());
                    resource.setKey("Copy of " + node.getKey());
                    target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(resource, this.this$0.resourceRestClient, this.this$0.connectorRestClient, pageRef).build("content", AjaxWizard.Mode.CREATE))});
                    this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.clone"), node.getKey()))));
                    this.this$0.modal.show(true);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While cloning resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)clone, (Action)RENDER, (String)"RESOURCE_CREATE");
        fragment.add(new Component[]{clone});
        return fragment;
    }

    public void onEvent(IEvent<?> event) {
        AjaxWizard.NewItemFinishEvent item;
        super.onEvent(event);
        Object object = event.getPayload();
        if (object instanceof AjaxWizard.NewItemFinishEvent && (object = (item = (AjaxWizard.NewItemFinishEvent)object).getResult()) instanceof ConnInstanceTO) {
            ConnInstanceTO connInstance = (ConnInstanceTO)object;
            item.getTarget().ifPresent(t -> this.setHeader((AjaxRequestTarget)t, connInstance.getDisplayName()));
        }
    }

    public static final class UpdateEvent {
        private final AjaxRequestTarget target;
        private final String key;

        public UpdateEvent(String key, AjaxRequestTarget target) {
            this.target = target;
            this.key = key;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKey() {
            return this.key;
        }
    }
}

