/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.ConnObjectDetails;
import org.apache.syncope.client.console.panels.ConnObjectListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class ConnObjects
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -1143512993584984838L;
    private final AjaxDropDownChoicePanel<String> anyTypes;
    private final MultilevelPanel connObjects;

    public ConnObjects(final ResourceTO resource, final PageReference pageRef) {
        super("content");
        List availableAnyTypes = resource.getProvisions().stream().map(Provision::getAnyType).sorted(AnyTypeRestClient.KEY_COMPARATOR).collect(Collectors.toList());
        if (resource.getOrgUnit() != null) {
            availableAnyTypes.addFirst("REALM");
        }
        this.anyTypes = new AjaxDropDownChoicePanel("anyTypes", "anyTypes", (IModel)new Model());
        this.anyTypes.setChoices(availableAnyTypes);
        this.anyTypes.hideLabel();
        this.anyTypes.setNullValid(false);
        if (availableAnyTypes.contains(AnyTypeKind.USER.name())) {
            this.anyTypes.setDefaultModelObject((Object)AnyTypeKind.USER.name());
        } else if (availableAnyTypes.contains(AnyTypeKind.GROUP.name())) {
            this.anyTypes.setDefaultModelObject((Object)AnyTypeKind.GROUP.name());
        } else if (!availableAnyTypes.isEmpty()) {
            this.anyTypes.setDefaultModelObject(availableAnyTypes.getFirst());
        }
        this.add(new Component[]{this.anyTypes});
        this.connObjects = new MultilevelPanel("connObjects"){
            private static final long serialVersionUID = 1473786800290434002L;

            public void prev(AjaxRequestTarget target) {
                ConnObjects.this.anyTypes.setEnabled(true);
                target.add(new Component[]{ConnObjects.this.anyTypes});
                super.prev(target);
            }
        };
        this.connObjects.setFirstLevel((Panel)new NextableConnObjectDirectoryPanel(resource, (String)this.anyTypes.getField().getModelObject(), pageRef));
        this.connObjects.setOutputMarkupId(true);
        this.add(new Component[]{this.connObjects});
        this.anyTypes.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior(this, "change"){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ ConnObjects this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                this.this$0.connObjects.setFirstLevel((Panel)this.this$0.new NextableConnObjectDirectoryPanel(resource, (String)this.this$0.anyTypes.getField().getModelObject(), pageRef));
                target.add(new Component[]{this.this$0.connObjects});
            }
        }});
    }

    private class NextableConnObjectDirectoryPanel
    extends ConnObjectListViewPanel {
        private static final long serialVersionUID = 956427874406567048L;

        NextableConnObjectDirectoryPanel(ResourceTO resource, String anyType, PageReference pageRef) {
            super("first", resource, anyType, pageRef);
        }

        @Override
        protected void viewConnObject(ConnObject connObjectTO, AjaxRequestTarget target) {
            ConnObjects.this.anyTypes.setEnabled(false);
            target.add(new Component[]{ConnObjects.this.anyTypes});
            ConnObjects.this.connObjects.next((String)new StringResourceModel("connObject.view", (Component)this, (IModel)new Model((Serializable)connObjectTO)).getObject(), (MultilevelPanel.SecondLevel)new ConnObjectDetails(connObjectTO), target);
        }

        @Override
        protected void pullConnObject(String fiql, AjaxRequestTarget target, String resource, String anyType, String realm, boolean isOnSyncope, PageReference pageRef) {
            ConnObjects.this.anyTypes.setEnabled(false);
            target.add(new Component[]{ConnObjects.this.anyTypes});
            PullTaskTO pullTaskTO = new PullTaskTO();
            pullTaskTO.setDestinationRealm(realm);
            ConnObjects.this.connObjects.next("PULL " + resource, (MultilevelPanel.SecondLevel)new ReconTaskPanel(resource, (ProvisioningTaskTO)pullTaskTO, anyType, null, fiql, isOnSyncope, ConnObjects.this.connObjects, pageRef), target);
        }
    }
}

