/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine.savedrequest;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSavedRequestHandler
implements SavedRequestHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSavedRequestHandler.class);

    @Override
    public void save(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        String requestedUrl = this.getRequestedUrl(webContext, sessionStore);
        if (WebContextHelper.isPost(webContext)) {
            LOGGER.debug("requestedUrl with data: {}", (Object)requestedUrl);
            String formPost = HttpActionHelper.buildFormPostContent(webContext);
            sessionStore.set(webContext, "pac4jRequestedUrl", new OkAction(formPost));
        } else {
            LOGGER.debug("requestedUrl: {}", (Object)requestedUrl);
            sessionStore.set(webContext, "pac4jRequestedUrl", requestedUrl);
        }
    }

    protected String getRequestedUrl(WebContext context, SessionStore sessionStore) {
        return context.getFullRequestURL();
    }

    @Override
    public HttpAction restore(CallContext ctx, String defaultUrl) {
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        Optional<Object> optRequestedUrl = sessionStore.get(webContext, "pac4jRequestedUrl");
        Throwable requestedAction = null;
        if (optRequestedUrl.isPresent()) {
            sessionStore.set(webContext, "pac4jRequestedUrl", null);
            Object requestedUrl = optRequestedUrl.get();
            if (requestedUrl instanceof String) {
                requestedAction = new FoundAction((String)requestedUrl);
            } else if (requestedUrl instanceof RedirectionAction) {
                requestedAction = (RedirectionAction)requestedUrl;
            }
        }
        if (requestedAction == null) {
            requestedAction = new FoundAction(defaultUrl);
        }
        LOGGER.debug("requestedAction: {}", (Object)requestedAction.getMessage());
        if (requestedAction instanceof FoundAction) {
            return HttpActionHelper.buildRedirectUrlAction(webContext, ((FoundAction)requestedAction).getLocation());
        }
        return HttpActionHelper.buildFormPostContentAction(webContext, ((OkAction)requestedAction).getContent());
    }
}

