/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.util.spring.RestActuatorControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class RestActuatorEndpointHandlerMapping
extends RequestMappingHandlerMapping {
    private final EndpointMapping endpointMapping;
    private final CorsConfiguration corsConfiguration;
    private final Map<Object, RestActuatorControllerEndpoint> handlers;

    public RestActuatorEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<RestActuatorControllerEndpoint> endpoints, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.handlers = RestActuatorEndpointHandlerMapping.getHandlers(endpoints);
        this.corsConfiguration = corsConfiguration;
        this.setOrder(Integer.MIN_VALUE);
    }

    private static Map<Object, RestActuatorControllerEndpoint> getHandlers(Collection<RestActuatorControllerEndpoint> endpoints) {
        LinkedHashMap handlers = new LinkedHashMap();
        endpoints.forEach(endpoint -> handlers.put(endpoint.getEndpointBean(), endpoint));
        return Map.copyOf(handlers);
    }

    protected void initHandlerMethods() {
        this.handlers.keySet().forEach(x$0 -> this.detectHandlerMethods(x$0));
    }

    protected void registerHandlerMethod(@Nonnull Object handler, @Nonnull Method method, @Nonnull RequestMappingInfo mapping) {
        RestActuatorControllerEndpoint endpoint = this.handlers.get(handler);
        RequestMappingInfo mappingWithPatterns = this.withEndpointMappedPatterns(endpoint, mapping);
        super.registerHandlerMethod(handler, method, mappingWithPatterns);
    }

    private RequestMappingInfo withEndpointMappedPatterns(RestActuatorControllerEndpoint endpoint, RequestMappingInfo mapping) {
        Set<PathPattern> patterns = mapping.getPathPatternsCondition().getPatterns();
        if (patterns.isEmpty()) {
            patterns = Set.of(this.getPatternParser().parse(""));
        }
        String[] endpointMappedPatterns = (String[])patterns.stream().map(pattern -> this.getEndpointMappedPattern(endpoint, (PathPattern)pattern)).toArray(String[]::new);
        return mapping.mutate().paths(endpointMappedPatterns).build();
    }

    private String getEndpointMappedPattern(RestActuatorControllerEndpoint endpoint, PathPattern pattern) {
        return this.endpointMapping.createSubPath(endpoint.getRootPath() + String.valueOf(pattern));
    }

    protected boolean hasCorsConfigurationSource(@Nonnull Object handler) {
        return this.corsConfiguration != null;
    }

    protected CorsConfiguration initCorsConfiguration(@Nonnull Object handler, @Nonnull Method method, @Nonnull RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }
}

