/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.external.development.springboot.devtools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFF)
public class WicketDevToolsPropertyDefaultsPostProcessor
implements EnvironmentPostProcessor {
    private static final Map<String, Object> PROPERTIES;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (Boolean.TRUE.equals(this.isWicketDevToolsEnabled(environment) != false && this.isLocalApplication(environment)) && this.canAddProperties((Environment)environment)) {
            MapPropertySource propertySource = new MapPropertySource("wicketrefresh", PROPERTIES);
            environment.getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    private Boolean isWicketDevToolsEnabled(ConfigurableEnvironment environment) {
        Boolean devToolsEnabled = Boolean.TRUE;
        String devToolsEnabledString = environment.getProperty("wicket.spring.devtools.restart.enabled");
        if (devToolsEnabledString != null) {
            devToolsEnabled = devToolsEnabledString.equalsIgnoreCase("true");
        }
        return devToolsEnabled;
    }

    private boolean isLocalApplication(ConfigurableEnvironment environment) {
        return environment.getPropertySources().get("remoteUrl") == null;
    }

    private boolean canAddProperties(Environment environment) {
        return this.isRestarterInitialized() || this.isRemoteRestartEnabled(environment);
    }

    private boolean isRestarterInitialized() {
        try {
            Restarter restarter = Restarter.getInstance();
            return restarter != null && restarter.getInitialUrls() != null;
        }
        catch (Exception | NoClassDefFoundError ex) {
            return false;
        }
    }

    private boolean isRemoteRestartEnabled(Environment environment) {
        return environment.containsProperty("spring.devtools.remote.secret");
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("wicket.core.settings.general.configuration-type", "development");
        properties.put("wicket.core.settings.markup.strip-wicket-tags", "false");
        properties.put("wicket.core.settings.debug.component-use-check", "true");
        properties.put("wicket.core.settings.debug.development-utilities-enabled", "true");
        properties.put("wicket.core.settings.debug.ajax-debug-mode-enabled", "true");
        PROPERTIES = Collections.unmodifiableMap(properties);
    }
}

