/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.session.SessionStorageTypes;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.MissingSamlAuthnRequestException;
import org.apereo.cas.support.saml.idp.SamlIdPSessionManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.TicketValidationResult;
import org.apereo.cas.web.AbstractController;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPSOAP11Decoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Tag(name="SAML2")
public abstract class AbstractSamlIdPProfileHandlerController
extends AbstractController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlIdPProfileHandlerController.class);
    protected final SamlProfileHandlerConfigurationContext configurationContext;
    private final CasReentrantLock lock = new CasReentrantLock();

    protected static void logCasValidationAssertion(TicketValidationResult assertion) {
        LOGGER.debug("CAS Assertion Principal: [{}]", (Object)assertion.getPrincipal());
        LOGGER.debug("CAS Assertion Authentication Attributes: [{}]", (Object)assertion.getAttributes());
        LOGGER.debug("CAS Assertion Service: [{}]", (Object)assertion.getService());
    }

    protected static MessageContext bindRelayStateParameter(HttpServletRequest request, HttpServletResponse response, Pair<? extends RequestAbstractType, MessageContext> authnContext, String relayState) {
        MessageContext messageContext = (MessageContext)authnContext.getValue();
        LOGGER.trace("Relay state is [{}]", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        return messageContext;
    }

    @ExceptionHandler(value={PrincipalException.class, UnauthorizedServiceException.class, SamlException.class})
    protected ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView((Exception)ex);
    }

    @ExceptionHandler(value={MissingSamlAuthnRequestException.class})
    protected ModelAndView handleMissingAuthnRequest(HttpServletRequest req, Exception ex) {
        return WebUtils.produceErrorView((String)"saml2-idp/casSamlIdPErrorView", (Throwable)ex);
    }

    protected Optional<SamlRegisteredServiceMetadataAdaptor> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, RequestAbstractType authnRequest) {
        return SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
    }

    protected Optional<SamlRegisteredServiceMetadataAdaptor> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, String entityId) {
        return SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId);
    }

    protected SamlRegisteredService verifySamlRegisteredService(String serviceId, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            throw UnauthorizedServiceException.denied((String)"Could not verify/locate SAML registered service since no serviceId is provided");
        }
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(serviceId, request);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new String[]{serviceId}));
        LOGGER.debug("Checking service access in CAS service registry for [{}]", (Object)service);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed((RegisteredService)registeredService, (Service)service)) {
            LOGGER.warn("[{}] is not found in the registry or service access is denied.", (Object)serviceId);
            throw UnauthorizedServiceException.denied((String)"Rejected: %s".formatted(serviceId));
        }
        LOGGER.debug("Located SAML service in the registry as [{}] with the metadata location of [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getMetadataLocation());
        return registeredService;
    }

    protected AuthenticatedAssertionContext buildCasAssertion(Authentication authentication, Service service, RegisteredService registeredService, Map<String, List<Object>> attributesToCombine) throws Throwable {
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).applicationContext((ApplicationContext)this.getConfigurationContext().getOpenSamlConfigBean().getApplicationContext()).service(service).principal(authentication.getPrincipal()).build();
        Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(context);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService(registeredService).service(service).principal(authentication.getPrincipal()).applicationContext((ApplicationContext)this.getConfigurationContext().getOpenSamlConfigBean().getApplicationContext()).build();
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(usernameContext);
        attributes.putAll(attributesToCombine);
        Map authnAttributes = this.configurationContext.getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, null, Map.of(), registeredService);
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(principalId)).authenticationDate(DateTimeUtils.zonedDateTimeOf((TemporalAccessor)authentication.getAuthenticationDate()))).validFromDate(DateTimeUtils.zonedDateTimeOf((TemporalAccessor)authentication.getAuthenticationDate()))).attributes(CollectionUtils.merge((Map[])new Map[]{attributes, authnAttributes}))).build();
    }

    protected AuthenticatedAssertionContext buildCasAssertion(String principal, RegisteredService registeredService, Map<String, Object> attributes) {
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(principal)).attributes(attributes)).build();
    }

    protected ModelAndView issueAuthenticationRequestRedirect(Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.debug("Created service url [{}]", (Object)DigestUtils.abbreviate((String)serviceUrl));
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        String urlToRedirectTo = this.constructRedirectUrl(serviceUrl, Map.of("RelayState", StringUtils.defaultString((String)AbstractSamlIdPProfileHandlerController.fetchRelayState(request, pair)), "renew", BooleanUtils.toString((boolean)BooleanUtils.toBoolean((Boolean)authnRequest.isForceAuthn()), (String)"true", (String)""), "gateway", BooleanUtils.toString((boolean)BooleanUtils.toBoolean((Boolean)authnRequest.isPassive()), (String)"true", (String)"")));
        LOGGER.debug("Redirecting SAML authentication request to [{}]", (Object)urlToRedirectTo);
        SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type.isBrowserStorage()) {
            JEEContext context = new JEEContext(request, response);
            BrowserStorage sessionStorage = this.configurationContext.getSessionStore().getTrackableSession((WebContext)context).map(BrowserStorage.class::cast).orElseThrow(() -> new IllegalStateException("Unable to determine trackable session for storage"));
            sessionStorage.setDestinationUrl(urlToRedirectTo);
            return new ModelAndView("storage/casBrowserStorageWriteView", "browserStorage", (Object)sessionStorage);
        }
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        ModelAndView mv = new ModelAndView((View)new RedirectView(urlToRedirectTo));
        mv.setStatus((HttpStatusCode)HttpStatus.FOUND);
        return mv;
    }

    private String constructRedirectUrl(String serviceUrl, Map<String, String> parameters) throws Exception {
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        URIBuilder urlBuilder = new URIBuilder(properties.getServer().getLoginUrl());
        urlBuilder.addParameter("service", serviceUrl);
        parameters.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> urlBuilder.addParameter((String)entry.getKey(), EncodingUtils.urlEncode((String)((String)entry.getValue()))));
        return urlBuilder.build().toASCIIString();
    }

    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, Pair<? extends SignableSAMLObject, MessageContext> pair) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        URIBuilder builder = new URIBuilder(this.configurationContext.getCallbackService().getId());
        builder.addParameter("srid", authnRequest.getID());
        builder.addParameter("entityId", SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest));
        this.storeAuthenticationRequest(request, response, pair);
        String url = builder.build().toURL().toExternalForm();
        LOGGER.trace("Built service callback url [{}]", (Object)url);
        return url;
    }

    protected ModelAndView initiateAuthenticationRequest(Pair<? extends RequestAbstractType, MessageContext> pair, HttpServletResponse response, HttpServletRequest request) throws Throwable {
        this.autoConfigureCookiePath(request);
        this.verifySamlAuthenticationRequest(pair, request);
        Optional<TicketGrantingTicket> sso = this.singleSignOnSessionExists(pair, request, response);
        if (sso.isEmpty()) {
            return this.issueAuthenticationRequestRedirect(pair, request, response);
        }
        this.buildResponseBasedSingleSignOnSession(pair, sso.get(), request, response);
        return null;
    }

    protected void buildResponseBasedSingleSignOnSession(Pair<? extends RequestAbstractType, MessageContext> context, TicketGrantingTicket ticketGrantingTicket, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AuthnRequest authnRequest = (AuthnRequest)context.getLeft();
        String id = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(id);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new String[]{id}));
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(ticketGrantingTicket.getAuthentication()).registeredService((RegisteredService)registeredService).httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        AuthenticatedAssertionContext assertion = this.buildCasAssertion(ticketGrantingTicket.getAuthentication(), (Service)service, (RegisteredService)registeredService, Map.of());
        Pair<? extends RequestAbstractType, MessageContext> authenticationContext = this.buildAuthenticationContextPair(request, response, context);
        String binding = this.determineProfileBinding(authenticationContext, request);
        MessageContext messageContext = (MessageContext)authenticationContext.getRight();
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        SAMLBindingSupport.setRelayState((MessageContext)((MessageContext)authenticationContext.getRight()), (String)relayState);
        response.reset();
        ServiceTicketFactory factory = (ServiceTicketFactory)this.getConfigurationContext().getTicketFactory().get(ServiceTicket.class);
        ServiceTicket st = (ServiceTicket)factory.create(ticketGrantingTicket, (Service)service, false, ServiceTicket.class);
        this.getConfigurationContext().getTicketRegistry().addTicket((Ticket)st);
        this.getConfigurationContext().getTicketRegistry().updateTicket((Ticket)ticketGrantingTicket);
        this.buildSamlResponse(response, request, authenticationContext, Optional.of(assertion), binding, st.getId());
    }

    protected XMLObject buildSamlResponse(HttpServletResponse response, HttpServletRequest request, Pair<? extends RequestAbstractType, MessageContext> authenticationContext, Optional<AuthenticatedAssertionContext> casAssertion, String binding, String sessionIndex) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        Pair<SamlRegisteredService, SamlRegisteredServiceMetadataAdaptor> pair = this.getRegisteredServiceAndFacade(authnRequest, request);
        String entityId = ((SamlRegisteredServiceMetadataAdaptor)pair.getValue()).getEntityId();
        LOGGER.debug("Preparing SAML2 response for [{}]", (Object)entityId);
        Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().samlRequest((RequestAbstractType)authnRequest)).httpRequest(request)).httpResponse(response)).authenticatedAssertion(casAssertion)).registeredService((SamlRegisteredService)pair.getKey())).adaptor((SamlRegisteredServiceMetadataAdaptor)pair.getValue())).binding(binding)).messageContext((MessageContext)authenticationContext.getValue())).sessionIndex(sessionIndex)).build();
        XMLObject samlResponse = this.configurationContext.getResponseBuilder().build((SamlProfileBuilderContext)buildContext);
        LOGGER.info("Built the SAML2 response for [{}]", (Object)entityId);
        return samlResponse;
    }

    protected Pair<? extends RequestAbstractType, MessageContext> buildAuthenticationContextPair(HttpServletRequest request, HttpServletResponse response, Pair<? extends RequestAbstractType, MessageContext> authnContext) {
        String relayState = AbstractSamlIdPProfileHandlerController.fetchRelayState(request, authnContext);
        MessageContext messageContext = AbstractSamlIdPProfileHandlerController.bindRelayStateParameter(request, response, authnContext, relayState);
        return Pair.of((Object)((RequestAbstractType)authnContext.getLeft()), (Object)messageContext);
    }

    private static String fetchRelayState(HttpServletRequest request, Pair<? extends SignableSAMLObject, MessageContext> authnContext) {
        return Optional.ofNullable(SAMLBindingSupport.getRelayState((MessageContext)((MessageContext)authnContext.getValue()))).orElseGet(() -> request.getParameter("RelayState"));
    }

    protected Optional<TicketGrantingTicket> singleSignOnSessionExists(Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        if (Boolean.TRUE.equals(authnRequest.isForceAuthn())) {
            LOGGER.trace("Authentication request asks for forced authn. Ignoring existing single sign-on session, if any");
            return Optional.empty();
        }
        String cookie = this.configurationContext.getTicketGrantingTicketCookieGenerator().retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)cookie)) {
            LOGGER.trace("Single sign-on session cannot be found or determined. Ignoring single sign-on session");
            return Optional.empty();
        }
        TicketGrantingTicket ticketGrantingTicket = this.configurationContext.getTicketRegistrySupport().getTicketGrantingTicket(cookie);
        if (ticketGrantingTicket == null) {
            LOGGER.debug("Authentication transaction linked to single sign-on session cannot determined.");
            return Optional.empty();
        }
        Authentication authentication = ticketGrantingTicket.getAuthentication();
        LOGGER.debug("Located single sign-on authentication for principal [{}]", (Object)authentication.getPrincipal());
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(issuer);
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy((Service)service);
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest(request).httpServletResponse(response).build().attribute(Service.class.getName(), (Object)service).attribute(RegisteredService.class.getName(), (Object)registeredService).attribute(Issuer.class.getName(), (Object)issuer).attribute(Authentication.class.getName(), (Object)authentication).attribute(TicketGrantingTicket.class.getName(), (Object)cookie).attribute(AuthnRequest.class.getName(), (Object)authnRequest);
        SingleSignOnParticipationStrategy ssoStrategy = this.configurationContext.getSingleSignOnParticipationStrategy();
        LOGGER.debug("Checking for single sign-on participation for issuer [{}]", (Object)issuer);
        boolean ssoAvailable = ssoStrategy.supports(ssoRequest) && ssoStrategy.isParticipating(ssoRequest);
        return ssoAvailable ? Optional.of(ticketGrantingTicket) : Optional.empty();
    }

    protected Pair<SamlRegisteredService, SamlRegisteredServiceMetadataAdaptor> verifySamlAuthenticationRequest(Pair<? extends RequestAbstractType, MessageContext> authenticationContext, HttpServletRequest request) throws Throwable {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication request", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer, request);
        LOGGER.debug("Fetching SAML2 metadata adaptor for [{}]", (Object)issuer);
        Optional adaptor = SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
        if (adaptor.isEmpty()) {
            LOGGER.warn("No metadata could be found for [{}]", (Object)issuer);
            throw UnauthorizedServiceException.denied((String)"Cannot find metadata linked to %s".formatted(issuer));
        }
        SamlRegisteredServiceMetadataAdaptor facade = (SamlRegisteredServiceMetadataAdaptor)adaptor.get();
        this.verifyAuthenticationContextSignature(authenticationContext, request, (RequestAbstractType)authnRequest, facade, registeredService);
        String binding = this.determineProfileBinding(authenticationContext, request);
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((Pair)Pair.of((Object)authnRequest, (Object)((MessageContext)authenticationContext.getRight())), (SamlRegisteredServiceMetadataAdaptor)facade, (String)binding);
        LOGGER.debug("Determined SAML2 endpoint for authentication request as [{}]", (Object)StringUtils.defaultIfBlank((CharSequence)acs.getResponseLocation(), (CharSequence)acs.getLocation()));
        this.configurationContext.getOpenSamlConfigBean().logObject((XMLObject)authnRequest);
        return Pair.of((Object)registeredService, (Object)facade);
    }

    protected void verifyAuthenticationContextSignature(Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceMetadataAdaptor adaptor, SamlRegisteredService registeredService) throws Throwable {
        MessageContext ctx = (MessageContext)authenticationContext.getValue();
        this.verifyAuthenticationContextSignature(ctx, request, authnRequest, adaptor, registeredService);
    }

    protected void verifyAuthenticationContextSignature(MessageContext ctx, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceMetadataAdaptor adaptor, SamlRegisteredService registeredService) throws Throwable {
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.trace("The authentication context is not signed");
            if (adaptor.isAuthnRequestsSigned() && !registeredService.isSkipValidatingAuthnRequest()) {
                LOGGER.error("Metadata for [{}] says authentication requests are signed, yet request is not", (Object)adaptor.getEntityId());
                throw new SAMLException("Request is not signed but should be");
            }
            LOGGER.trace("Request is not signed or validation is skipped, so there is no need to verify its signature.");
        } else if (adaptor.isAuthnRequestsSigned() && !registeredService.isSkipValidatingAuthnRequest()) {
            LOGGER.trace("The authentication context is signed; Proceeding to validate signatures...");
            this.configurationContext.getSamlObjectSignatureValidator().verifySamlProfileRequest(authnRequest, adaptor, request, ctx);
        }
    }

    protected Pair<SamlRegisteredService, SamlRegisteredServiceMetadataAdaptor> getRegisteredServiceAndFacade(AuthnRequest authnRequest, HttpServletRequest httpServletRequest) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication context", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer, httpServletRequest);
        LOGGER.debug("Located SAML metadata for [{}]", (Object)registeredService.getServiceId());
        Optional<SamlRegisteredServiceMetadataAdaptor> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)authnRequest);
        if (adaptor.isEmpty()) {
            throw UnauthorizedServiceException.denied((String)"Cannot find metadata linked to %s".formatted(issuer));
        }
        SamlRegisteredServiceMetadataAdaptor facade = adaptor.get();
        return Pair.of((Object)registeredService, (Object)facade);
    }

    protected MessageContext decodeSoapRequest(final HttpServletRequest request) {
        return (MessageContext)FunctionUtils.doAndHandle((CheckedSupplier)new CheckedSupplier<MessageContext>(){

            public MessageContext get() throws Throwable {
                HTTPSOAP11Decoder decoder = new HTTPSOAP11Decoder();
                decoder.setParserPool(AbstractSamlIdPProfileHandlerController.this.configurationContext.getOpenSamlConfigBean().getParserPool());
                decoder.setHttpServletRequestSupplier(() -> request);
                BindingDescriptor binding = new BindingDescriptor();
                binding.setId(this.getClass().getName());
                binding.setShortName(this.getClass().getName());
                binding.setSignatureCapable(true);
                binding.setSynchronous(true);
                decoder.setBindingDescriptor(binding);
                decoder.initialize();
                decoder.decode();
                return decoder.getMessageContext();
            }
        }, throwable -> null).get();
    }

    protected void autoConfigureCookiePath(HttpServletRequest request) {
        CasConfigurationProperties casProperties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties core = casProperties.getAuthn().getSamlIdp().getCore();
        SessionStorageTypes sessionStorageType = core.getSessionStorageType();
        if (sessionStorageType.isTicketRegistry() && core.getSessionReplication().getCookie().isAutoConfigureCookiePath()) {
            CasCookieBuilder cookieBuilder = this.configurationContext.getSamlDistributedSessionCookieGenerator();
            CookieUtils.configureCookiePath((HttpServletRequest)request, (CasCookieBuilder)cookieBuilder);
        }
    }

    protected ModelAndView handleSsoPostProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) {
        return (ModelAndView)FunctionUtils.doAndHandle(() -> {
            Pair<? extends SignableSAMLObject, MessageContext> result = this.getConfigurationContext().getSamlHttpRequestExtractor().extract(request, decoder, AuthnRequest.class).orElseThrow(() -> new IllegalArgumentException("Unable to extract SAML request"));
            Pair context = Pair.of((Object)((AuthnRequest)result.getLeft()), (Object)((MessageContext)result.getRight()));
            return this.initiateAuthenticationRequest((Pair<? extends RequestAbstractType, MessageContext>)context, response, request);
        }, WebUtils::produceErrorView).get();
    }

    protected final Pair<? extends RequestAbstractType, MessageContext> retrieveAuthenticationRequest(HttpServletResponse response, HttpServletRequest request) {
        return (Pair)this.lock.tryLock(() -> {
            LOGGER.info("Received SAML2 callback profile request [{}]", (Object)request.getRequestURI());
            JEEContext webContext = new JEEContext(request, response);
            return (Pair)SamlIdPSessionManager.of((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (SessionStore)this.configurationContext.getSessionStore()).fetch((WebContext)webContext, AuthnRequest.class).orElseThrow(() -> {
                String samlAuthnRequestId = webContext.getRequestParameter("srid").orElse("N/A");
                String message = "SAML2 authentication request cannot be determined from the CAS session store for request id %s.\nThis typically means that the original SAML2 authentication request that was submitted to CAS via a SAML2 service provider\ncannot be retrieved and restored after an authentication attempt. If you are running a multi-node CAS deployment, you may\nneed to opt for a different session storage mechanism than what is configured now: %s\n";
                return new MissingSamlAuthnRequestException("SAML2 authentication request cannot be determined from the CAS session store for request id %s.\nThis typically means that the original SAML2 authentication request that was submitted to CAS via a SAML2 service provider\ncannot be retrieved and restored after an authentication attempt. If you are running a multi-node CAS deployment, you may\nneed to opt for a different session storage mechanism than what is configured now: %s\n".stripIndent().stripLeading().trim().formatted(samlAuthnRequestId, this.configurationContext.getSessionStore().getClass().getName()));
            });
        });
    }

    protected void storeAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, Pair<? extends SignableSAMLObject, MessageContext> context) {
        this.lock.tryLock(__ -> {
            JEEContext webContext = new JEEContext(request, response);
            SamlIdPSessionManager.of((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (SessionStore)this.configurationContext.getSessionStore()).store((WebContext)webContext, context);
        });
    }

    protected String determineProfileBinding(Pair<? extends RequestAbstractType, MessageContext> authenticationContext, HttpServletRequest request) {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        Pair<SamlRegisteredService, SamlRegisteredServiceMetadataAdaptor> pair = this.getRegisteredServiceAndFacade(authnRequest, request);
        SamlRegisteredServiceMetadataAdaptor facade = (SamlRegisteredServiceMetadataAdaptor)pair.getValue();
        String binding = (String)StringUtils.defaultIfBlank((CharSequence)authnRequest.getProtocolBinding(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        LOGGER.debug("Determined authentication request binding is [{}], issued by [{}]", (Object)binding, (Object)authnRequest.getIssuer().getValue());
        String entityId = facade.getEntityId();
        LOGGER.debug("Checking metadata for [{}] to see if binding [{}] is supported", (Object)entityId, (Object)binding);
        AssertionConsumerService svc = facade.getAssertionConsumerService(binding);
        LOGGER.debug("Binding [{}] is supported by [{}]", (Object)svc.getBinding(), (Object)entityId);
        return binding;
    }

    @Generated
    protected AbstractSamlIdPProfileHandlerController(SamlProfileHandlerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public SamlProfileHandlerConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }
}

