/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.mfa.trigger.AdaptiveMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.AuthenticationAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.GlobalMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.GroovyScriptMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.HttpRequestMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.PredicatedPrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.PrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RegisteredServiceMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RegisteredServicePrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RestEndpointMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.ScriptedRegisteredServiceMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.TimedMultifactorAuthenticationTrigger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.SpringResourceProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderSelectionCookieProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.AccountProfileDeleteMultifactorAuthenticationDeviceAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationAvailableAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationBypassAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationFailureAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.composite.MultifactorProviderSelectedAction;
import org.apereo.cas.web.flow.actions.composite.MultifactorProviderSelectionAction;
import org.apereo.cas.web.flow.actions.composite.PrepareMultifactorProviderSelectionAction;
import org.apereo.cas.web.flow.authentication.ChainingMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.authentication.GroovyScriptMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.authentication.RankedMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.configurer.CompositeProviderSelectionMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.MultifactorAuthenticationAccountProfileWebflowConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.CompositeProviderSelectionMultifactorWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.DefaultCasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.RankedMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.SelectiveMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.mgmr.NoOpCookieValueManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Webflow})
@ConditionalOnWebApplication
@AutoConfiguration
public class CasCoreMultifactorAuthenticationWebflowAutoConfiguration {

    @Configuration(value="CasCoreMultifactorAuthenticationAccountProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    static class CasCoreMultifactorAuthenticationAccountProfileConfiguration {
        CasCoreMultifactorAuthenticationAccountProfileConfiguration() {
        }

        @ConditionalOnMissingBean(name={"accountProfileMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer accountProfileMultifactorWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).alwaysMatch().supply(() -> new MultifactorAuthenticationAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"accountProfileDeleteMultifactorAuthenticationDeviceAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action accountProfileDeleteMultifactorAuthenticationDeviceAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(AccountProfileDeleteMultifactorAuthenticationDeviceAction::new).withId("accountProfileDeleteMultifactorAuthenticationDeviceAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileMultifactorWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer accountProfileMultifactorWebflowExecutionPlanConfigurer(@Qualifier(value="accountProfileMultifactorWebflowConfigurer") CasWebflowConfigurer duoMultifactorAccountProfileWebflowConfigurer, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).alwaysMatch().supply(() -> plan -> plan.registerWebflowConfigurer(duoMultifactorAccountProfileWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreMultifactorAuthenticationProviderCompositeConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreMultifactorAuthenticationProviderCompositeConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.core.provider-selection.provider-selection-enabled").isTrue();
        private static final BeanCondition COOKIE_CONDITION = CONDITION.toStartWith().and("cas.authn.mfa.core.provider-selection.cookie.enabled").isTrue().evenIfMissing();

        CasCoreMultifactorAuthenticationProviderCompositeConfiguration() {
        }

        @ConditionalOnMissingBean(name={"multifactorAuthenticationProviderSelectionCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder multifactorAuthenticationProviderSelectionCookieGenerator(ConfigurableApplicationContext applicationContext, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
            return (CasCookieBuilder)BeanSupplier.of(CasCookieBuilder.class).when(COOKIE_CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                MultifactorAuthenticationProviderSelectionCookieProperties cookie = casProperties.getAuthn().getMfa().getCore().getProviderSelection().getCookie();
                CookieGenerationContext context = CookieUtils.buildCookieGenerationContext((CookieProperties)cookie);
                return new CookieRetrievingCookieGenerator(context, (CookieValueManager)new NoOpCookieValueManager(tenantExtractor));
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"compositeProviderSelectionMultifactorWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer compositeProviderSelectionMultifactorWebflowConfigurer(@Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CompositeProviderSelectionMultifactorWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"compositeProviderSelectionCasWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer compositeProviderSelectionCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="compositeProviderSelectionMultifactorWebflowConfigurer") CasWebflowConfigurer compositeProviderSelectionMultifactorWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(compositeProviderSelectionMultifactorWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreMultifactorAuthenticationProviderSelectiveConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreMultifactorAuthenticationProviderSelectiveConfiguration {
        CasCoreMultifactorAuthenticationProviderSelectiveConfiguration() {
        }

        @ConditionalOnMissingBean(name={"selectiveAuthenticationProviderWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver selectiveAuthenticationProviderWebflowEventResolver(@Qualifier(value="multifactorAuthenticationProviderSelectionCookieGenerator") CasCookieBuilder multifactorAuthenticationProviderSelectionCookieGenerator, CasConfigurationProperties casProperties, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return casProperties.getAuthn().getMfa().getCore().getProviderSelection().isProviderSelectionEnabled() ? new CompositeProviderSelectionMultifactorWebflowEventResolver(casWebflowConfigurationContext, multifactorAuthenticationProviderSelectionCookieGenerator) : new SelectiveMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext);
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowActionsConfiguration {
        CasMultifactorAuthenticationWebflowActionsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaAvailableAction"})
        public Action mfaAvailableAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationAvailableAction(tenantExtractor)).withId("mfaAvailableAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaBypassAction"})
        public Action mfaBypassAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationBypassAction(tenantExtractor)).withId("mfaBypassAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaFailureAction"})
        public Action mfaFailureAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationFailureAction(tenantExtractor)).withId("mfaFailureAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"multifactorProviderSelectedAction"})
        public Action multifactorProviderSelectedAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="multifactorAuthenticationProviderSelectionCookieGenerator") CasCookieBuilder multifactorAuthenticationProviderSelectionCookieGenerator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorProviderSelectedAction(multifactorAuthenticationProviderSelectionCookieGenerator, casProperties)).withId("multifactorProviderSelectedAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"compositeMfaProviderSelectionAction"})
        public Action compositeMfaProviderSelectionAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(MultifactorProviderSelectionAction::new).withId("compositeMfaProviderSelectionAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"prepareMultifactorProviderSelectionAction"})
        public Action prepareMultifactorProviderSelectionAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new PrepareMultifactorProviderSelectionAction(casProperties)).withId("prepareMultifactorProviderSelectionAction").build().get();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowContextConfiguration {
        CasMultifactorAuthenticationWebflowContextConfiguration() {
        }

        @ConditionalOnMissingBean(name={"initialAuthenticationAttemptWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver(@Qualifier(value="selectiveAuthenticationProviderWebflowEventResolver") CasWebflowEventResolver selectiveAuthenticationProviderWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="adaptiveAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver adaptiveAuthenticationPolicyWebflowEventResolver, @Qualifier(value="timedAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver timedAuthenticationPolicyWebflowEventResolver, @Qualifier(value="globalAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver globalAuthenticationPolicyWebflowEventResolver, @Qualifier(value="httpRequestAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver httpRequestAuthenticationPolicyWebflowEventResolver, @Qualifier(value="restEndpointAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver restEndpointAuthenticationPolicyWebflowEventResolver, @Qualifier(value="groovyScriptAuthenticationPolicyWebflowEventResolver") ObjectProvider<CasWebflowEventResolver> groovyScriptAuthenticationPolicyWebflowEventResolver, @Qualifier(value="scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver, @Qualifier(value="registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver") CasWebflowEventResolver predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver, @Qualifier(value="principalAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver principalAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="authenticationAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver authenticationAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="registeredServiceAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver registeredServiceAuthenticationPolicyWebflowEventResolver) {
            DefaultCasDelegatingWebflowEventResolver resolver = new DefaultCasDelegatingWebflowEventResolver(casWebflowConfigurationContext, selectiveAuthenticationProviderWebflowEventResolver);
            resolver.addDelegate(adaptiveAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(timedAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(globalAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(httpRequestAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(restEndpointAuthenticationPolicyWebflowEventResolver);
            groovyScriptAuthenticationPolicyWebflowEventResolver.ifAvailable(arg_0 -> ((DefaultCasDelegatingWebflowEventResolver)resolver).addDelegate(arg_0));
            resolver.addDelegate(scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver);
            resolver.addDelegate(principalAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(authenticationAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(registeredServiceAuthenticationPolicyWebflowEventResolver);
            return resolver;
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowSelectorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowSelectorConfiguration {
        CasMultifactorAuthenticationWebflowSelectorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"multifactorAuthenticationProviderSelector"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector(ConfigurableApplicationContext applicationContext, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, CasConfigurationProperties casProperties) {
            MultifactorAuthenticationProperties mfa = casProperties.getAuthn().getMfa();
            SpringResourceProperties script = mfa.getCore().getProviderSelection().getProviderSelectorGroovyScript();
            if (script.getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
                return new GroovyScriptMultifactorAuthenticationProviderSelector(script.getLocation());
            }
            if (mfa.getCore().getProviderSelection().isProviderSelectionEnabled()) {
                return new ChainingMultifactorAuthenticationProviderSelector(applicationContext, failureModeEvaluator);
            }
            return new RankedMultifactorAuthenticationProviderSelector();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowResolverConfiguration {
        CasMultifactorAuthenticationWebflowResolverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"multifactorAuthenticationProviderResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver(List<MultifactorAuthenticationPrincipalResolver> resolvers) {
            AnnotationAwareOrderComparator.sort(resolvers);
            return new DefaultMultifactorAuthenticationProviderResolver(resolvers);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultMultifactorAuthenticationPrincipalResolver"})
        public MultifactorAuthenticationPrincipalResolver defaultMultifactorAuthenticationPrincipalResolver() {
            return MultifactorAuthenticationPrincipalResolver.identical();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowTriggersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowTriggersConfiguration {
        CasMultifactorAuthenticationWebflowTriggersConfiguration() {
        }

        @ConditionalOnMissingBean(name={"groovyScriptAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public CasWebflowEventResolver groovyScriptAuthenticationPolicyWebflowEventResolver(@Qualifier(value="groovyScriptMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger groovyScriptMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, groovyScriptMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"httpRequestAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver httpRequestAuthenticationPolicyWebflowEventResolver(@Qualifier(value="httpRequestMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger httpRequestMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, httpRequestMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"restEndpointAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver restEndpointAuthenticationPolicyWebflowEventResolver(@Qualifier(value="restEndpointMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger restEndpointMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, restEndpointMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"globalAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver globalAuthenticationPolicyWebflowEventResolver(@Qualifier(value="globalMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger globalMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, globalMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"adaptiveAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver adaptiveAuthenticationPolicyWebflowEventResolver(@Qualifier(value="adaptiveMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger adaptiveMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, adaptiveMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"registeredServiceAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver registeredServiceAuthenticationPolicyWebflowEventResolver(@Qualifier(value="registeredServiceMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger registeredServiceMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, registeredServiceMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver(@Qualifier(value="predicatedPrincipalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger predicatedPrincipalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, predicatedPrincipalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"principalAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver principalAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="principalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger principalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, principalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver(@Qualifier(value="scriptedRegisteredServiceMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger scriptedRegisteredServiceMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, scriptedRegisteredServiceMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"timedAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver timedAuthenticationPolicyWebflowEventResolver(@Qualifier(value="timedMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger timedMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, timedMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="registeredServicePrincipalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger registeredServicePrincipalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, registeredServicePrincipalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"authenticationAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver authenticationAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="authenticationAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger authenticationAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, authenticationAttributeMultifactorAuthenticationTrigger);
        }

        @Bean
        @ConditionalOnMissingBean(name={"scriptedRegisteredServiceMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger scriptedRegisteredServiceMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new ScriptedRegisteredServiceMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext, tenantExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"registeredServicePrincipalAttributeMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger registeredServicePrincipalAttributeMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RegisteredServicePrincipalAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext, multifactorAuthenticationProviderSelector, tenantExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"restEndpointMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger restEndpointMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RestEndpointMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"registeredServiceMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger registeredServiceMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RegisteredServiceMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderSelector, applicationContext, tenantExtractor);
        }

        @ConditionalOnMissingBean(name={"adaptiveMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger adaptiveMultifactorAuthenticationTrigger(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new AdaptiveMultifactorAuthenticationTrigger((GeoLocationService)geoLocationService.getIfAvailable(), casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"globalMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger globalMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new GlobalMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext, multifactorAuthenticationProviderSelector, tenantExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"timedMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger timedMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new TimedMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"groovyScriptMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public MultifactorAuthenticationTrigger groovyScriptMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (MultifactorAuthenticationTrigger)BeanSupplier.of(MultifactorAuthenticationTrigger.class).when(BeanCondition.on((String)"cas.authn.mfa.groovy-script.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).when(ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory().isPresent()).supply(() -> {
                Resource groovyScript = casProperties.getAuthn().getMfa().getGroovyScript().getLocation();
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                ExecutableCompiledScript watchableScript = scriptFactory.fromResource(groovyScript);
                return new GroovyScriptMultifactorAuthenticationTrigger(watchableScript, (ApplicationContext)applicationContext, multifactorAuthenticationProviderResolver, multifactorAuthenticationProviderSelector, tenantExtractor);
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"httpRequestMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger httpRequestMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new HttpRequestMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"principalAttributeMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger principalAttributeMultifactorAuthenticationTrigger(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new PrincipalAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext, tenantExtractor);
        }

        @ConditionalOnMissingBean(name={"authenticationAttributeMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger authenticationAttributeMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new AuthenticationAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"predicatedPrincipalAttributeMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger predicatedPrincipalAttributeMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (MultifactorAuthenticationTrigger)BeanSupplier.of(MultifactorAuthenticationTrigger.class).when(BeanCondition.on((String)"cas.authn.mfa.triggers.global-principal-attribute-predicate.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new PredicatedPrincipalAttributeMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext)).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"defaultMultifactorTriggerSelectionStrategy"})
        public MultifactorAuthenticationTriggerSelectionStrategy defaultMultifactorTriggerSelectionStrategy(List<MultifactorAuthenticationTrigger> triggers) {
            List activeTriggers = triggers.stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
            AnnotationAwareOrderComparator.sortIfNecessary(activeTriggers);
            return new DefaultMultifactorAuthenticationTriggerSelectionStrategy(activeTriggers);
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowRankedEventConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasMultifactorAuthenticationWebflowRankedEventConfiguration {
        CasMultifactorAuthenticationWebflowRankedEventConfiguration() {
        }

        @ConditionalOnMissingBean(name={"rankedAuthenticationProviderWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public CasDelegatingWebflowEventResolver rankedAuthenticationProviderWebflowEventResolver(@Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy) {
            return new RankedMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, initialAuthenticationAttemptWebflowEventResolver, authenticationContextValidator, webflowSingleSignOnParticipationStrategy);
        }
    }
}

