/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.streampark.common.util.MemorySize;
import org.apache.streampark.common.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;
import org.snakeyaml.engine.v2.schema.CoreSchema;
import org.snakeyaml.engine.v2.schema.Schema;

public class YamlParserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YamlParserUtils.class);
    private static final DumpSettings blockerDumperSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setSplitLines(false).setSchema((Schema)new CoreSchema()).build();
    private static final DumpSettings flowDumperSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.FLOW).setSplitLines(false).setSchema((Schema)new CoreSchema()).build();
    private static final Dump blockerDumper = new Dump(blockerDumperSettings, (BaseRepresenter)new FlinkConfigRepresenter(blockerDumperSettings));
    private static final Dump flowDumper = new Dump(flowDumperSettings, (BaseRepresenter)new FlinkConfigRepresenter(flowDumperSettings));
    private static final Load loader = new Load(LoadSettings.builder().setSchema((Schema)new CoreSchema()).build());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static synchronized Map<String, Object> loadYamlFile(File file) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Map yamlResult = (Map)loader.loadFromInputStream((InputStream)inputStream);
            Map map = yamlResult == null ? new HashMap() : yamlResult;
            return map;
        }
        catch (FileNotFoundException e) {
            LOG.error("Failed to find YAML file", (Throwable)e);
            throw e;
        }
        catch (IOException | YamlEngineException e) {
            if (!(e instanceof MarkedYamlEngineException)) throw e;
            YamlEngineException exception = YamlParserUtils.wrapExceptionToHiddenSensitiveData((MarkedYamlEngineException)e);
            LOG.error("Failed to parse YAML configuration", (Throwable)exception);
            throw exception;
        }
    }

    @Nonnull
    public static synchronized Map<String, Object> loadYamlInput(InputStream inputStream) throws Exception {
        try {
            Map yamlResult = (Map)loader.loadFromInputStream(inputStream);
            return yamlResult == null ? new HashMap() : yamlResult;
        }
        catch (YamlEngineException e) {
            if (e instanceof MarkedYamlEngineException) {
                YamlEngineException exception = YamlParserUtils.wrapExceptionToHiddenSensitiveData((MarkedYamlEngineException)e);
                LOG.error("Failed to parse YAML configuration", (Throwable)exception);
                throw exception;
            }
            throw e;
        }
    }

    @Nonnull
    public static synchronized Map<String, Object> loadYamlString(String text) {
        try {
            Map yamlResult = (Map)loader.loadFromString(text);
            return yamlResult == null ? new HashMap() : yamlResult;
        }
        catch (YamlEngineException e) {
            if (e instanceof MarkedYamlEngineException) {
                YamlEngineException exception = YamlParserUtils.wrapExceptionToHiddenSensitiveData((MarkedYamlEngineException)e);
                LOG.error("Failed to parse YAML configuration", (Throwable)exception);
                throw exception;
            }
            throw e;
        }
    }

    public static synchronized String toYAMLString(Object value) {
        try {
            String output = flowDumper.dumpToString(value);
            String linebreak = flowDumperSettings.getBestLineBreak();
            if (output.endsWith(linebreak)) {
                output = output.substring(0, output.length() - linebreak.length());
            }
            return output;
        }
        catch (MarkedYamlEngineException exception) {
            throw YamlParserUtils.wrapExceptionToHiddenSensitiveData(exception);
        }
    }

    public static synchronized List<String> convertAndDumpYamlFromFlatMap(Map<String, Object> flattenMap) {
        try {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : flattenMap.entrySet()) {
                String[] keys = entry.getKey().split("\\.");
                Map<String, Object> currentMap = nestedMap;
                for (int i = 0; i < keys.length - 1; ++i) {
                    currentMap = (Map)currentMap.computeIfAbsent(keys[i], k -> new LinkedHashMap());
                }
                currentMap.put(keys[keys.length - 1], entry.getValue());
            }
            String data = blockerDumper.dumpToString(nestedMap);
            String linebreak = blockerDumperSettings.getBestLineBreak();
            return Arrays.asList(data.split(linebreak));
        }
        catch (MarkedYamlEngineException exception) {
            throw YamlParserUtils.wrapExceptionToHiddenSensitiveData(exception);
        }
    }

    public static synchronized <T> T convertToObject(String value, Class<T> type) {
        try {
            return type.cast(loader.loadFromString(value));
        }
        catch (MarkedYamlEngineException exception) {
            throw YamlParserUtils.wrapExceptionToHiddenSensitiveData(exception);
        }
    }

    private static YamlEngineException wrapExceptionToHiddenSensitiveData(MarkedYamlEngineException exception) {
        Throwable cause;
        StringBuilder lines = new StringBuilder();
        String context = exception.getContext();
        Optional contextMark = exception.getContextMark();
        Optional problemMark = exception.getProblemMark();
        String problem = exception.getProblem();
        if (context != null) {
            lines.append(context);
            lines.append("\n");
        }
        if (contextMark.isPresent() && (problem == null || !problemMark.isPresent() || ((Mark)contextMark.get()).getName().equals(((Mark)problemMark.get()).getName()) || ((Mark)contextMark.get()).getLine() != ((Mark)problemMark.get()).getLine() || ((Mark)contextMark.get()).getColumn() != ((Mark)problemMark.get()).getColumn())) {
            lines.append(YamlParserUtils.hiddenSensitiveDataInMark((Mark)contextMark.get()));
            lines.append("\n");
        }
        if (problem != null) {
            lines.append(problem);
            lines.append("\n");
        }
        if (problemMark.isPresent()) {
            lines.append(YamlParserUtils.hiddenSensitiveDataInMark((Mark)problemMark.get()));
            lines.append("\n");
        }
        if ((cause = exception.getCause()) instanceof MarkedYamlEngineException) {
            cause = YamlParserUtils.wrapExceptionToHiddenSensitiveData((MarkedYamlEngineException)cause);
        }
        YamlEngineException yamlException = new YamlEngineException(lines.toString(), cause);
        yamlException.setStackTrace(exception.getStackTrace());
        return yamlException;
    }

    private static String hiddenSensitiveDataInMark(Mark mark) {
        return " in " + mark.getName() + ", line " + (mark.getLine() + 1) + ", column " + (mark.getColumn() + 1);
    }

    private static class FlinkConfigRepresenter
    extends StandardRepresenter {
        public FlinkConfigRepresenter(DumpSettings dumpSettings) {
            super(dumpSettings);
            this.representers.put(Duration.class, this::representDuration);
            this.representers.put(MemorySize.class, this::representMemorySize);
            this.parentClassRepresenters.put(Enum.class, this::representEnum);
        }

        private Node representDuration(Object data) {
            Duration duration = (Duration)data;
            String durationString = TimeUtils.formatWithHighestUnit(duration);
            return new ScalarNode(Tag.STR, durationString, this.settings.getDefaultScalarStyle());
        }

        private Node representMemorySize(Object data) {
            MemorySize memorySize = (MemorySize)data;
            return new ScalarNode(Tag.STR, memorySize.toString(), this.settings.getDefaultScalarStyle());
        }

        private Node representEnum(Object data) {
            return new ScalarNode(Tag.STR, data.toString(), this.settings.getDefaultScalarStyle());
        }
    }
}

