/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public class DataSourceClassPathResolver
extends DataSourceBaseResolver {
    private final String classPathBase;

    public DataSourceClassPathResolver() {
        this.classPathBase = "/";
    }

    public DataSourceClassPathResolver(String classPathBase) {
        this.classPathBase = classPathBase.endsWith("/") ? classPathBase : classPathBase + "/";
    }

    public DataSourceClassPathResolver(String classPathBase, boolean lenient) {
        super(lenient);
        this.classPathBase = classPathBase.endsWith("/") ? classPathBase : classPathBase + "/";
    }

    public String getClassPathBase() {
        return this.classPathBase;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        ByteArrayDataSource result = null;
        try {
            if (!this.isCid(resourceLocation) && !this.isHttpUrl(resourceLocation)) {
                String mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(resourceLocation);
                String resourceName = this.getResourceName(resourceLocation);
                InputStream is = DataSourceClassPathResolver.class.getResourceAsStream(resourceName);
                if (is != null) {
                    try {
                        ByteArrayDataSource ds = new ByteArrayDataSource(is, mimeType);
                        ds.setName(DataSourceClassPathResolver.class.getResource(resourceName).toString());
                        result = ds;
                    }
                    finally {
                        is.close();
                    }
                } else {
                    if (isLenient) {
                        return null;
                    }
                    throw new IOException("The following class path resource was not found : " + resourceLocation);
                }
            }
            return result;
        }
        catch (IOException e) {
            if (isLenient) {
                return null;
            }
            throw e;
        }
    }

    private String getResourceName(String resourceLocation) {
        return (this.getClassPathBase() + resourceLocation).replaceAll("//", "/");
    }
}

