/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

@Internal
public abstract class JobMetricGroup<C extends ComponentMetricGroup<C>>
extends ComponentMetricGroup<C> {
    protected final JobID jobId;
    @Nullable
    protected final String jobName;

    protected JobMetricGroup(MetricRegistry registry, C parent, JobID jobId, @Nullable String jobName, String[] scope) {
        super(registry, scope, parent);
        this.jobId = jobId;
        this.jobName = jobName;
    }

    public JobID jobId() {
        return this.jobId;
    }

    @Nullable
    public String jobName() {
        return this.jobName;
    }

    @Override
    protected QueryScopeInfo.JobQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.JobQueryScopeInfo(this.jobId.toString());
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_JOB_ID, this.jobId.toString());
        variables.put(ScopeFormat.SCOPE_JOB_NAME, this.jobName);
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "job";
    }
}

