/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import scala.util.Properties;

@TableName(value="t_flink_env")
public class FlinkEnv
implements Serializable {
    @TableId(type=IdType.AUTO)
    private Long id;
    private String flinkName;
    private String flinkHome;
    private String flinkConf;
    private String description;
    private String scalaVersion;
    private String version;
    private Boolean isDefault;
    private Date createTime;
    private transient FlinkVersion flinkVersion;
    private transient String streamParkScalaVersion = Properties.versionNumberString();
    private static final Float FLINK_CONFIG_CHANGE_VERSION = Float.valueOf(1.19f);
    private static final String LEGACY_CONFIG_FILE = "flink-conf.yaml";
    private static final String NEW_CONFIG_FILE = "config.yaml";
    private static final String CONF_DIR = "/conf/";

    public void doSetFlinkConf() throws ApiDetailException {
        Float version = this.getVersionNumber();
        File configFile = this.resolveConfigFile(version);
        this.flinkConf = configFile.getAbsolutePath();
    }

    private File resolveConfigFile(Float version) throws ApiAlertException {
        String confDir = this.flinkHome + CONF_DIR;
        if (version.floatValue() < FLINK_CONFIG_CHANGE_VERSION.floatValue()) {
            File configFile = new File(confDir + LEGACY_CONFIG_FILE);
            if (!configFile.exists()) {
                throw new ApiAlertException(String.format("Cannot find %s in %s for Flink version %s", LEGACY_CONFIG_FILE, confDir, this.version));
            }
            return configFile;
        }
        if (version.equals(FLINK_CONFIG_CHANGE_VERSION)) {
            File legacyConfigFile = new File(confDir + LEGACY_CONFIG_FILE);
            if (legacyConfigFile.exists()) {
                return legacyConfigFile;
            }
            File newConfigFile = new File(confDir + NEW_CONFIG_FILE);
            if (newConfigFile.exists()) {
                return newConfigFile;
            }
            throw new ApiAlertException(String.format("Cannot find either %s or %s in %s for Flink version %s", LEGACY_CONFIG_FILE, NEW_CONFIG_FILE, confDir, this.version));
        }
        File configFile = new File(confDir + NEW_CONFIG_FILE);
        if (!configFile.exists()) {
            throw new ApiAlertException(String.format("Cannot find %s in %s for Flink version %s", NEW_CONFIG_FILE, confDir, this.version));
        }
        return configFile;
    }

    public void doSetVersion() {
        this.setVersion(this.getFlinkVersion().version());
        this.setScalaVersion(this.getFlinkVersion().scalaVersion());
        if (!this.streamParkScalaVersion.startsWith(this.getFlinkVersion().scalaVersion())) {
            throw new UnsupportedOperationException(String.format("The current Scala version of StreamPark is %s, but the scala version of Flink to be added is %s, which does not match, Please check", this.streamParkScalaVersion, this.getFlinkVersion().scalaVersion()));
        }
    }

    public Map<String, String> convertFlinkYamlAsMap() {
        String flinkYamlString = DeflaterUtils.unzipString((String)this.flinkConf);
        return PropertiesUtils.loadFlinkConfYaml((String)flinkYamlString);
    }

    @JsonIgnore
    public FlinkVersion getFlinkVersion() {
        if (this.flinkVersion == null) {
            this.flinkVersion = new FlinkVersion(this.flinkHome);
        }
        return this.flinkVersion;
    }

    public void unzipFlinkConf() {
        this.flinkConf = DeflaterUtils.unzipString((String)this.flinkConf);
    }

    @JsonIgnore
    public String getLargeVersion() {
        return this.version.substring(0, this.version.lastIndexOf("."));
    }

    @JsonIgnore
    public String getVersionOfFirst() {
        return this.version.split("\\.")[0];
    }

    @JsonIgnore
    public String getVersionOfMiddle() {
        return this.version.split("\\.")[1];
    }

    @JsonIgnore
    public String getVersionOfLast() {
        return this.version.split("\\.")[2];
    }

    @JsonIgnore
    private Float getVersionNumber() {
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            return Float.valueOf(Float.parseFloat(this.getVersionOfFirst() + "." + this.getVersionOfMiddle()));
        }
        throw new RuntimeException("Flink version is null");
    }

    @JsonIgnore
    public boolean isLegacyFlinkConf() {
        return this.getVersionNumber().floatValue() < FLINK_CONFIG_CHANGE_VERSION.floatValue();
    }

    public Long getId() {
        return this.id;
    }

    public String getFlinkName() {
        return this.flinkName;
    }

    public String getFlinkHome() {
        return this.flinkHome;
    }

    public String getFlinkConf() {
        return this.flinkConf;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getStreamParkScalaVersion() {
        return this.streamParkScalaVersion;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFlinkName(String flinkName) {
        this.flinkName = flinkName;
    }

    public void setFlinkHome(String flinkHome) {
        this.flinkHome = flinkHome;
    }

    public void setFlinkConf(String flinkConf) {
        this.flinkConf = flinkConf;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScalaVersion(String scalaVersion) {
        this.scalaVersion = scalaVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setFlinkVersion(FlinkVersion flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public void setStreamParkScalaVersion(String streamParkScalaVersion) {
        this.streamParkScalaVersion = streamParkScalaVersion;
    }
}

