% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/stats.R
\name{sampleBy}
\alias{sampleBy}
\alias{sampleBy,SparkDataFrame,character,list,numeric-method}
\title{Returns a stratified sample without replacement}
\usage{
sampleBy(x, col, fractions, seed)

\S4method{sampleBy}{SparkDataFrame,character,list,numeric}(x, col, fractions, seed)
}
\arguments{
\item{x}{A SparkDataFrame}

\item{col}{column that defines strata}

\item{fractions}{A named list giving sampling fraction for each stratum. If a stratum is
not specified, we treat its fraction as zero.}

\item{seed}{random seed}
}
\value{
A new SparkDataFrame that represents the stratified sample
}
\description{
Returns a stratified sample without replacement based on the fraction given on each
stratum.
}
\note{
sampleBy since 1.6.0
}
\examples{
\dontrun{
df <- read.json("/path/to/file.json")
sample <- sampleBy(df, "key", fractions, 36)
}
}
\seealso{
Other stat functions: 
\code{\link{approxQuantile}()},
\code{\link{corr}()},
\code{\link{cov}()},
\code{\link{crosstab}()},
\code{\link{freqItems}()}
}
\concept{stat functions}
